/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.refactoring;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.splevo.commons.emf.ReplacementUtil;
import org.splevo.refactoring.ResourceProcessorService;
import org.splevo.refactoring.VariabilityRefactoring;
import org.splevo.vpm.software.SoftwareElement;
import org.splevo.vpm.variability.Variant;
import org.splevo.vpm.variability.VariationPoint;

public abstract class FullyAutomatedVariabilityRefactoring
implements VariabilityRefactoring {
    private static final Logger LOGGER = Logger.getLogger(FullyAutomatedVariabilityRefactoring.class);
    private final Map<EObject, EObject> replacements = Maps.newHashMap();
    private final Map<String, Set<EObject>> variantSpecificelements = Maps.newHashMap();

    @Override
    public List<Resource> refactor(VariationPoint variationPoint, Map<String, Object> refactoringConfigurations) {
        new ResourceProcessorService().processVPBeforeFullyAutomatedRefactoring(variationPoint);
        List<Resource> changedResources = this.refactorFullyAutomated(variationPoint, refactoringConfigurations);
        this.fixVPMAfterRefactoring(variationPoint);
        variationPoint.setRefactored(true);
        return changedResources;
    }

    protected abstract List<Resource> refactorFullyAutomated(VariationPoint var1, Map<String, Object> var2);

    protected abstract SoftwareElement createSoftwareElement(EObject var1);

    protected void executeReplacement(Map.Entry<EObject, EObject> replacement, VariationPoint variationPoint) {
        LOGGER.debug((Object)String.format("Replacing %s with %s.", replacement.getKey(), replacement.getValue()));
        ReplacementUtil.replaceCrossReferences((EObject)replacement.getKey(), (EObject)replacement.getValue(), (ResourceSet[])new ResourceSet[]{variationPoint.eResource().getResourceSet()});
    }

    protected <T extends EObject> T clone(T eobject) {
        EObject copy = EcoreUtil.copy(eobject);
        this.registerReplacement(eobject, copy);
        return (T)copy;
    }

    protected void registerReplacement(Iterable<? extends EObject> originals, EObject replacement) {
        Iterable filteredOriginals = Iterables.filter(originals, (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)replacement)));
        for (EObject original : filteredOriginals) {
            this.registerReplacement(original, replacement);
        }
    }

    protected void registerVariantSpecificNewEObject(EObject eobject, String variantId) {
        if (!this.variantSpecificelements.containsKey(variantId)) {
            this.variantSpecificelements.put(variantId, new HashSet());
        }
        this.variantSpecificelements.get(variantId).add(eobject);
    }

    protected void registerReplacement(EObject original, EObject replacement) {
        if (this.replacements.containsKey(original)) {
            LOGGER.debug((Object)String.format("Registered duplicate replacement for %s. Old entry %s is replaced with new entry %s.", original, this.replacements.get(original), replacement));
        }
        this.replacements.put(original, replacement);
    }

    private static Iterable<EObject> getAllParents(EObject eobject, boolean includeSelf) {
        ArrayList parents = Lists.newArrayList();
        if (includeSelf) {
            parents.add(eobject);
        }
        EObject target = eobject.eContainer();
        while (target != null) {
            parents.add(target);
            EObject newTarget = eobject.eContainer();
            if (newTarget == target) break;
            target = newTarget;
        }
        return parents;
    }

    private static PartitionedReplacements partitionReplacements(Map<EObject, EObject> replacements, Map<String, Set<EObject>> variantSpecificelements) {
        HashSet allNewVariantSpecificElements = Sets.newHashSet((Iterable)Iterables.concat(variantSpecificelements.values()));
        Predicate<Map.Entry<EObject, EObject>> partitionPredicate = new Predicate<Map.Entry<EObject, EObject>>(){

            public boolean apply(Map.Entry<EObject, EObject> arg0) {
                HashSet parents = Sets.newHashSet((Iterable)FullyAutomatedVariabilityRefactoring.getAllParents(arg0.getValue(), true));
                return Sets.intersection((Set)parents, (Set)allNewVariantSpecificElements).size() < 1;
            }
        };
        PartitionedReplacements partitionedRefinements = new PartitionedReplacements();
        for (Map.Entry<EObject, EObject> replacement : replacements.entrySet()) {
            if (partitionPredicate.apply(replacement)) {
                partitionedRefinements.getApply().add(replacement);
                continue;
            }
            partitionedRefinements.getDelete().add(replacement);
        }
        return partitionedRefinements;
    }

    private void removeSoftwareElement(EObject eobject, VariationPoint variationPoint) {
        for (Variant variant : variationPoint.getVariants()) {
            Iterator swElementIterator = variant.getImplementingElements().iterator();
            while (swElementIterator.hasNext()) {
                if (((SoftwareElement)swElementIterator.next()).getWrappedElement() != eobject) continue;
                swElementIterator.remove();
                return;
            }
        }
    }

    private static Map<EObject, EObject> calculateTransitiveClosure(Map<EObject, EObject> map) {
        HashMap closure = Maps.newHashMap();
        for (Map.Entry<EObject, EObject> entry : map.entrySet()) {
            EObject start = entry.getKey();
            EObject end = entry.getValue();
            while (map.containsKey(end)) {
                end = map.get(end);
            }
            closure.put(start, end);
        }
        return closure;
    }

    private void fixVPMAfterRefactoring(VariationPoint variationPoint) {
        Map<EObject, EObject> replacementsClosure = FullyAutomatedVariabilityRefactoring.calculateTransitiveClosure(this.replacements);
        PartitionedReplacements partitionedReplacements = FullyAutomatedVariabilityRefactoring.partitionReplacements(replacementsClosure, this.variantSpecificelements);
        for (Map.Entry<EObject, EObject> entry : partitionedReplacements.getApply()) {
            this.executeReplacement(entry, variationPoint);
        }
        for (Map.Entry<EObject, EObject> entry : partitionedReplacements.getDelete()) {
            LOGGER.debug((Object)String.format("Removing %s from VP.", entry.getKey()));
            this.removeSoftwareElement(entry.getKey(), variationPoint);
        }
        for (Map.Entry<Object, Object> entry : this.variantSpecificelements.entrySet()) {
            String variantId = (String)entry.getKey();
            Variant variant = (Variant)Iterables.find((Iterable)variationPoint.getVariants(), (Predicate)new Predicate<Variant>(){

                public boolean apply(Variant arg0) {
                    return variantId.equals(arg0.getId());
                }
            });
            if (variant == null) {
                LOGGER.warn((Object)("Elements have been registered to the invalid variant ID " + variantId + ". Ignoring the entries."));
                continue;
            }
            for (EObject eobject : (Set)entry.getValue()) {
                SoftwareElement swElement = this.createSoftwareElement(eobject);
                if (swElement == null) {
                    LOGGER.warn((Object)("We were unable to create a SoftwareElement for the EObject " + eobject + "."));
                }
                variant.getImplementingElements().add((Object)swElement);
            }
        }
    }

    private static class PartitionedReplacements {
        private final List<Map.Entry<EObject, EObject>> apply = Lists.newArrayList();
        private final List<Map.Entry<EObject, EObject>> delete = Lists.newArrayList();

        private PartitionedReplacements() {
        }

        public List<Map.Entry<EObject, EObject>> getApply() {
            return this.apply;
        }

        public List<Map.Entry<EObject, EObject>> getDelete() {
            return this.delete;
        }
    }
}

