/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.refactoring;

import org.splevo.refactoring.VariabilityRefactoring;
import org.splevo.refactoring.VariabilityRefactoringRegistry;
import org.splevo.vpm.VPMValidator;
import org.splevo.vpm.variability.VariationPoint;

public class RefactoringSpecificVPMValidator
implements VPMValidator {
    public VPMValidator.VPMValidationResult validate(VariationPoint vp) {
        VariabilityRefactoring ref = this.getVariabilityRefactoring(vp);
        if (ref != null && ref.canBeAppliedTo(vp).getSeverity() != 0) {
            return new VPMValidator.VPMValidationResult(false, String.format("The refactoring %s does not match the defined characteristics.", ref.getClass().getSimpleName()));
        }
        return new VPMValidator.VPMValidationResult();
    }

    private VariabilityRefactoring getVariabilityRefactoring(VariationPoint vp) {
        if (vp.getVariabilityMechanism() == null) {
            return null;
        }
        String refactoringId = vp.getVariabilityMechanism().getRefactoringID();
        return (VariabilityRefactoring)VariabilityRefactoringRegistry.getInstance().getElementById(refactoringId);
    }
}

