/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.refactoring;

import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.resource.Resource;
import org.osgi.framework.BundleException;
import org.splevo.commons.eclipse.ExtensionHelper;
import org.splevo.commons.registry.RegistryBase;
import org.splevo.refactoring.ResourceProcessor;
import org.splevo.vpm.variability.VariationPoint;
import org.splevo.vpm.variability.VariationPointModel;

public class ResourceProcessorService {
    private static final Logger LOGGER = Logger.getLogger(ResourceProcessorService.class);
    private static final String RESOURCE_PROCESSOR_EXTENSION_ID = "org.splevo.refactoring.resourceprocessor";
    private static final RegistryBase<ResourceProcessor> RESOURCE_PROCESSOR_REGISTRY = new RegistryBase<ResourceProcessor>(){};

    static {
        Iterable<Object> extensions = Collections.emptyList();
        try {
            extensions = ExtensionHelper.getAllRegisteredExtensions((String)RESOURCE_PROCESSOR_EXTENSION_ID, ResourceProcessor.class);
        }
        catch (BundleException bundleException) {
            LOGGER.error((Object)"Could not access the extension for resource processors.", (Throwable)bundleException);
        }
        for (ResourceProcessor resourceProcessor : extensions) {
            RESOURCE_PROCESSOR_REGISTRY.registerElement((Object)resourceProcessor);
        }
    }

    public void processResourcesBeforeRefactorings(Iterable<Resource> resources) {
        List processors = RESOURCE_PROCESSOR_REGISTRY.getElements();
        for (Resource resource : resources) {
            for (ResourceProcessor processor : processors) {
                processor.processBeforeRefactoring(resource);
            }
        }
    }

    public void processVPMBeforeRefactorings(VariationPointModel variationPointModel) {
        List processors = RESOURCE_PROCESSOR_REGISTRY.getElements();
        for (ResourceProcessor processor : processors) {
            processor.processVPMBeforeRefactoring(variationPointModel);
        }
    }

    public void processVPBeforeFullyAutomatedRefactoring(VariationPoint variationPoint) {
        List processors = RESOURCE_PROCESSOR_REGISTRY.getElements();
        for (ResourceProcessor processor : processors) {
            processor.processVPBeforeFullyAutomatedRefactoring(variationPoint);
        }
    }

    public void postprocessResources(Iterable<Resource> resources) {
        List processors = RESOURCE_PROCESSOR_REGISTRY.getElements();
        for (Resource resource : resources) {
            for (ResourceProcessor processor : processors) {
                processor.processAfterRefactoring(resource);
            }
        }
    }

    public void processVPMAfterRefactorings(VariationPointModel variationPointModel) {
        List processors = RESOURCE_PROCESSOR_REGISTRY.getElements();
        for (ResourceProcessor processor : processors) {
            processor.processVPMAfterRefactorings(variationPointModel);
        }
    }
}

