/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.refactoring;

import com.google.common.base.Strings;
import org.apache.log4j.Logger;
import org.splevo.commons.interfaces.IdHavingElement;
import org.splevo.commons.registry.IdBasedRegistryBase;
import org.splevo.refactoring.VariabilityRefactoring;

public enum VariabilityRefactoringRegistry {
    INSTANCE;

    private final InnerVariabilityRefactoringRegistry innerRegistry = new InnerVariabilityRefactoringRegistry();

    public static InnerVariabilityRefactoringRegistry getInstance() {
        return VariabilityRefactoringRegistry.INSTANCE.innerRegistry;
    }

    public class InnerVariabilityRefactoringRegistry
    extends IdBasedRegistryBase<VariabilityRefactoring, String> {
        private final Logger logger = Logger.getLogger(InnerVariabilityRefactoringRegistry.class);

        protected int compareElements(VariabilityRefactoring element1, VariabilityRefactoring element2) {
            String name1 = element1.getVariabilityMechanism().getName();
            String name2 = element2.getVariabilityMechanism().getName();
            return Strings.nullToEmpty((String)name1).compareTo(name2);
        }

        protected boolean isValid(VariabilityRefactoring element) {
            if (!super.isValid((IdHavingElement)element)) {
                return false;
            }
            if (element.getVariabilityMechanism() == null) {
                this.logger.warn((Object)("Tried to register refactoring without a variability mechanism " + element));
                return false;
            }
            return true;
        }
    }
}

