/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.refactoring;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.splevo.refactoring.FullyAutomatedVariabilityRefactoring;
import org.splevo.refactoring.RecommenderResult;
import org.splevo.refactoring.ResourceProcessorService;
import org.splevo.refactoring.SemiAutomatedVariabilityRefactoring;
import org.splevo.refactoring.VariabilityRefactoring;
import org.splevo.refactoring.VariabilityRefactoringFailedException;
import org.splevo.refactoring.VariabilityRefactoringRegistry;
import org.splevo.vpm.realization.VariabilityMechanism;
import org.splevo.vpm.software.SoftwareElement;
import org.splevo.vpm.variability.VariationPoint;
import org.splevo.vpm.variability.VariationPointGroup;
import org.splevo.vpm.variability.VariationPointModel;

public class VariabilityRefactoringService {
    public static final String JAVA_SOURCE_DIRECTORY = "JaMoPP.Refactoring.Options.SourceDirectory";
    public static final String SPLEVO_PROJECT = "SPLEVO_PROJECT";
    private static Logger logger = Logger.getLogger(VariabilityRefactoringService.class);

    public void refactor(VariationPointModel variationPointModel, Map<String, Object> refactoringConfigurations) {
        this.preprocessResources(variationPointModel);
        EcoreUtil.resolveAll((EObject)variationPointModel);
        this.preprocessVPM(variationPointModel);
        HashSet<Resource> toBeSaved = new HashSet<Resource>();
        for (VariationPointGroup vpGroup : variationPointModel.getVariationPointGroups()) {
            for (VariationPoint variationPoint : vpGroup.getVariationPoints()) {
                String refactoringID = variationPoint.getVariabilityMechanism().getRefactoringID();
                VariabilityRefactoring refactoring = (VariabilityRefactoring)VariabilityRefactoringRegistry.getInstance().getElementById(refactoringID);
                if (refactoring.canBeAppliedTo(variationPoint).getSeverity() != 0) {
                    logger.debug((Object)"Recommended refactoring cannot be applied to this variation point.");
                    continue;
                }
                List<Resource> changedResources = refactoring.refactor(variationPoint, refactoringConfigurations);
                toBeSaved.addAll(changedResources);
            }
        }
        this.postprocess(variationPointModel, toBeSaved);
    }

    public void refactorFullyAutomated(VariabilityRefactoring refactoring, VariationPointModel vpm, VariationPoint variationPoint, Map<String, Object> refactoringConfigurations) throws VariabilityRefactoringFailedException {
        if (refactoring.canBeAppliedTo(variationPoint).getSeverity() != 0) {
            throw new VariabilityRefactoringFailedException("Recommended refactoring cannot be applied to this variation point.");
        }
        if (!(refactoring instanceof FullyAutomatedVariabilityRefactoring)) {
            throw new VariabilityRefactoringFailedException("The given refactoring is no fully automated refactoring.");
        }
        List<Resource> changedResources = refactoring.refactor(variationPoint, refactoringConfigurations);
        this.postprocess(vpm, Sets.newHashSet(changedResources));
    }

    public void refactorSemiAutomated(VariationPointModel vpm, VariationPoint variationPoint, Map<String, Object> refactoringConfigurations) throws VariabilityRefactoringFailedException {
        String refactoringID = variationPoint.getVariabilityMechanism().getRefactoringID();
        VariabilityRefactoring refactoring = (VariabilityRefactoring)VariabilityRefactoringRegistry.getInstance().getElementById(refactoringID);
        if (refactoring.canBeAppliedTo(variationPoint).getSeverity() != 0) {
            throw new VariabilityRefactoringFailedException("Recommended refactoring cannot be applied to this variation point.");
        }
        if (!(refactoring instanceof SemiAutomatedVariabilityRefactoring)) {
            throw new VariabilityRefactoringFailedException("The given refactoring is no fully automated refactoring.");
        }
        List<Resource> changedResources = ((SemiAutomatedVariabilityRefactoring)refactoring).startManualRefactoring(variationPoint, refactoringConfigurations);
        this.postprocess(vpm, Sets.newHashSet(changedResources));
    }

    private void postprocess(VariationPointModel variationPointModel, Set<Resource> toBeSaved) {
        EcoreUtil.resolveAll((EObject)variationPointModel);
        this.postprocessVPM(variationPointModel);
        this.saveVPM(variationPointModel);
        this.saveAndPostprocessResources(toBeSaved);
    }

    private void postprocessVPM(VariationPointModel variationPointModel) {
        new ResourceProcessorService().processVPMAfterRefactorings(variationPointModel);
    }

    private void saveAndPostprocessResources(Set<Resource> toBeSaved) {
        for (Resource resource : toBeSaved) {
            this.saveResource(resource);
        }
        this.postprocessResources(toBeSaved);
        for (Resource resource : toBeSaved) {
            this.saveResource(resource);
        }
    }

    private void postprocessResources(Set<Resource> toBeSaved) {
        new ResourceProcessorService().postprocessResources(toBeSaved);
    }

    private void preprocessVPM(VariationPointModel variationPointModel) {
        new ResourceProcessorService().processVPMBeforeRefactorings(variationPointModel);
        this.saveVPM(variationPointModel);
    }

    private void preprocessResources(VariationPointModel variationPointModel) {
        Iterable resourcesOfAllSoftwareElements = Iterables.transform((Iterable)variationPointModel.getSoftwareElements(), (Function)new Function<SoftwareElement, Resource>(){

            public Resource apply(SoftwareElement arg0) {
                return arg0.getWrappedElement().eResource();
            }
        });
        Iterable nonNullResources = Iterables.filter((Iterable)resourcesOfAllSoftwareElements, (Predicate)Predicates.notNull());
        HashSet resources = Sets.newHashSet((Iterable)nonNullResources);
        new ResourceProcessorService().processResourcesBeforeRefactorings(resources);
    }

    public RecommenderResult recommendMechanisms(VariationPointModel variationPointModel, List<VariabilityRefactoring> refactorings) {
        RecommenderResult result = new RecommenderResult();
        for (VariationPointGroup group : variationPointModel.getVariationPointGroups()) {
            for (VariationPoint vp : group.getVariationPoints()) {
                if (vp.getVariabilityMechanism() != null) continue;
                VariabilityRefactoring bestRefactoring = this.getBestMatchingRefactoring(vp, refactorings);
                if (bestRefactoring == null) {
                    result.getUnassignedVariationPoints().add(vp);
                    continue;
                }
                VariabilityMechanism mechanism = bestRefactoring.getVariabilityMechanism();
                vp.setVariabilityMechanism(mechanism);
            }
        }
        if (!this.saveVPM(variationPointModel)) {
            result.setStatus(RecommenderResult.Status.FAILED);
        }
        return result;
    }

    private VariabilityRefactoring getBestMatchingRefactoring(VariationPoint vp, List<VariabilityRefactoring> refactorings) {
        for (VariabilityRefactoring refactoring : refactorings) {
            if (refactoring.canBeAppliedTo(vp).getSeverity() != 0) continue;
            return refactoring;
        }
        return null;
    }

    private boolean saveVPM(VariationPointModel variationPointModel) {
        if (variationPointModel.eResource() != null) {
            return this.saveResource(variationPointModel.eResource());
        }
        logger.info((Object)"Variation Point Model without a resource");
        return true;
    }

    private boolean saveResource(Resource resource) {
        try {
            resource.save(null);
        }
        catch (IOException e) {
            logger.error((Object)("Could not save resource: " + resource.getURI().lastSegment()), (Throwable)e);
            return false;
        }
        return true;
    }
}

