/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.tests;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.emftext.language.java.JavaClasspath;
import org.splevo.extraction.SoftwareModelExtractionException;
import org.splevo.jamopp.diffing.JaMoPPDiffer;
import org.splevo.jamopp.extraction.JaMoPPSoftwareModelExtractor;
import org.splevo.jamopp.vpm.builder.JaMoPPVPMBuilder;
import org.splevo.vpm.analyzer.DefaultVPMAnalyzerService;
import org.splevo.vpm.analyzer.graph.VPMGraph;
import org.splevo.vpm.variability.VariationPointModel;

public class SPLevoTestUtil {
    private static final File NATIVE_DIR = new File("testmodels/implementation/gcd/native");
    private static final File JSCIENCE_DIR = new File("testmodels/implementation/gcd/jscience");

    public static VPMGraph loadGCDVPMGraph() throws Exception {
        VariationPointModel vpm = SPLevoTestUtil.loadGCDVPMModel();
        DefaultVPMAnalyzerService service = new DefaultVPMAnalyzerService();
        VPMGraph graph = service.initVPMGraph(vpm);
        return graph;
    }

    public static VariationPointModel loadGCDVPMModel() throws Exception {
        Comparison diffModel = SPLevoTestUtil.loadGCDDiffModel();
        JaMoPPVPMBuilder jamoppVPMBuilder = new JaMoPPVPMBuilder();
        VariationPointModel initialVpm = jamoppVPMBuilder.buildVPM(diffModel, "LEADING", "INTEGRATION");
        return initialVpm;
    }

    private static Comparison loadGCDDiffModel() throws Exception {
        StringBuilder ignorePackages = new StringBuilder();
        ignorePackages.append("java.*");
        ignorePackages.append(System.getProperty("line.separator"));
        ignorePackages.append("org.jscience.*");
        ignorePackages.append(System.getProperty("line.separator"));
        ignorePackages.append("javolution.*");
        LinkedHashMap<String, String> diffOptions = new LinkedHashMap<String, String>();
        diffOptions.put("JaMoPP.Java.Packages.to.ignore", ignorePackages.toString());
        JaMoPPDiffer differ = new JaMoPPDiffer((JaMoPPSoftwareModelExtractor)new JaMoPPSoftwareModelExtractorWithJarHandling());
        Comparison diffModel = differ.doDiff(NATIVE_DIR.toURI(), JSCIENCE_DIR.toURI(), diffOptions);
        return diffModel;
    }

    private static class JaMoPPSoftwareModelExtractorWithJarHandling
    extends JaMoPPSoftwareModelExtractor {
        private static final Logger LOGGER = Logger.getLogger(JaMoPPSoftwareModelExtractorWithJarHandling.class);

        private JaMoPPSoftwareModelExtractorWithJarHandling() {
        }

        protected List<Resource> loadProjectJavaFiles(ResourceSet targetResourceSet, Iterable<String> projectPaths) throws SoftwareModelExtractionException {
            JavaClasspath classpath = (JavaClasspath)Iterables.find((Iterable)targetResourceSet.eAdapters(), (Predicate)Predicates.instanceOf(JavaClasspath.class));
            for (String jarFilePath : this.getAllJarFiles(projectPaths)) {
                classpath.registerClassifierJar(URI.createFileURI((String)jarFilePath));
            }
            return super.loadProjectJavaFiles(targetResourceSet, projectPaths);
        }

        private List<String> getAllJarFiles(Iterable<String> projectPaths) {
            ArrayList jarPaths = Lists.newArrayList();
            for (String projectPath : projectPaths) {
                Collection jarFiles = FileUtils.listFiles((File)new File(projectPath), (String[])new String[]{"jar"}, (boolean)true);
                for (File jarPath : jarFiles) {
                    try {
                        jarPaths.add(jarPath.getCanonicalPath());
                    }
                    catch (IOException e) {
                        LOGGER.warn((Object)("Unable to access jar file: " + jarPath));
                    }
                }
            }
            return jarPaths;
        }
    }
}

