/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.ui.commons.util;

import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.splevo.project.SPLevoProject;

public final class WorkspaceUtil {
    private WorkspaceUtil() {
    }

    public static String getAbsoluteFromProjectRelativePath(String projectRelativePath, SPLevoProject splevoProject) {
        String workspaceRelativePath = String.format("%s%s%s", StringUtils.removeEndIgnoreCase((String)splevoProject.getWorkspace(), (String)"/"), projectRelativePath.startsWith("/") ? "" : "/", projectRelativePath);
        return WorkspaceUtil.getAbsoluteFromWorkspaceRelativePath(workspaceRelativePath);
    }

    public static String getAbsoluteFromWorkspaceRelativePath(String relativePath) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        return String.format("%s%s%s", root.getLocation().toPortableString(), relativePath.startsWith("/") ? "" : "/", relativePath);
    }

    public static String getSourceModelPathWithinEclipse(SPLevoProject splevoProject, String variantName) {
        return WorkspaceUtil.getAbsoluteFromProjectRelativePath("models/sourcemodels/" + variantName, splevoProject);
    }

    public static String getAbsoluteWorkspacePath() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        String basePath = String.valueOf(workspace.getRoot().getRawLocation().toOSString()) + "/";
        return basePath;
    }
}

