/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.ui.commons.vpm;

import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.splevo.refactoring.VariabilityRefactoring;
import org.splevo.refactoring.VariabilityRefactoringRegistry;
import org.splevo.vpm.realization.VariabilityMechanism;
import org.splevo.vpm.variability.VariationPoint;

public class VPMAttributeSetter {
    public static boolean applyIfPossible(SetAndRevertAction<VariationPoint> action, VariationPoint vp) {
        action.set(vp);
        VariabilityMechanism mechanism = vp.getVariabilityMechanism();
        if (mechanism == null) {
            return true;
        }
        VariabilityRefactoring ref = (VariabilityRefactoring)VariabilityRefactoringRegistry.getInstance().getElementById((Object)mechanism.getRefactoringID());
        if (ref == null) {
            return true;
        }
        Diagnostic diagnostic = ref.canBeAppliedTo(vp);
        if (diagnostic.getSeverity() != 0) {
            StringBuilder errorMessage = new StringBuilder();
            errorMessage.append("The following errors occured during validation:\n\n");
            errorMessage.append(String.valueOf(diagnostic.getMessage()) + "\n");
            errorMessage.append("\nYour changes have been discarded.");
            MessageDialog dialog = new MessageDialog(Display.getDefault().getActiveShell(), "Validation Errors", null, errorMessage.toString(), 0, VPMAttributeSetter.getDialogLabels(diagnostic), 0);
            if (dialog.open() == 1) {
                MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)"Validation Errors", (String)VPMAttributeSetter.getDiagnosticChildrenMessage(diagnostic));
            }
            action.revert(vp);
            return false;
        }
        return true;
    }

    private static String[] getDialogLabels(Diagnostic diagnostic) {
        if (diagnostic.getChildren().size() > 0) {
            return new String[]{"OK", "More Information"};
        }
        return new String[]{"OK"};
    }

    private static String getDiagnosticChildrenMessage(Diagnostic diagnostic) {
        StringBuilder message = new StringBuilder();
        message.append("The following errors occured during validation:\n\n");
        for (Diagnostic childDiagnostic : diagnostic.getChildren()) {
            message.append(String.valueOf(childDiagnostic.getMessage()) + "\n");
        }
        return message.toString();
    }

    public static interface SetAndRevertAction<T extends EObject> {
        public void set(T var1);

        public void revert(T var1);
    }
}

