/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.ui.commons.project;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.splevo.project.utils.SPLevoProjectUtil;
import org.splevo.ui.commons.project.SPLevoProjectWorkspaceListener;

public class SPLevoProjectWorkspaceObserver {
    private static final Logger LOGGER = Logger.getLogger(SPLevoProjectWorkspaceObserver.class);
    private final IResourceChangeListener projecListener = this.createProjectOpenCloseListener();
    private final Set<SPLevoProjectWorkspaceListener> subscribers = Sets.newHashSet();
    private final List<IProject> projects = Lists.newArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerSubscriber(SPLevoProjectWorkspaceListener listener) {
        Set<SPLevoProjectWorkspaceListener> set = this.subscribers;
        synchronized (set) {
            this.subscribers.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterSubscriber(SPLevoProjectWorkspaceListener listener) {
        Set<SPLevoProjectWorkspaceListener> set = this.subscribers;
        synchronized (set) {
            this.subscribers.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startObserver() {
        List<IProject> list = this.projects;
        synchronized (list) {
            this.projects.clear();
            Iterables.addAll(this.projects, this.determineSPLevoProjects());
            ResourcesPlugin.getWorkspace().addResourceChangeListener(this.projecListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopObserver() {
        List<IProject> list = this.projects;
        synchronized (list) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.projecListener);
            this.projects.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<IProject> getCurrentState() {
        List<IProject> list = this.projects;
        synchronized (list) {
            return this.projects;
        }
    }

    private IResourceChangeListener createProjectOpenCloseListener() {
        return new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                if (event.getType() == 2) {
                    SPLevoProjectWorkspaceObserver.this.handleClosedProject((IProject)event.getResource());
                    return;
                }
                if (event.getType() == 1) {
                    try {
                        event.getDelta().accept(new IResourceDeltaVisitor(){

                            public boolean visit(IResourceDelta delta) throws CoreException {
                                IProject project;
                                if (delta.getResource() instanceof IWorkspaceRoot) {
                                    return true;
                                }
                                if ((delta.getFlags() & 0x4000) != 0 && delta.getResource() instanceof IProject && (project = (IProject)delta.getResource()).isOpen()) {
                                    SPLevoProjectWorkspaceObserver.this.handleOpenedProject(project);
                                }
                                return false;
                            }
                        });
                    }
                    catch (CoreException e) {
                        LOGGER.warn((Object)"Error processing a resource change. The VPM loading composite might not be up to date anymore.", (Throwable)e);
                    }
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleOpenedProject(IProject project) {
        List<IProject> list = this.projects;
        synchronized (list) {
            if (SPLevoProjectUtil.isSPLevoProject((IProject)project)) {
                this.projects.add(project);
                this.notifySubscribers();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleClosedProject(IProject project) {
        List<IProject> list = this.projects;
        synchronized (list) {
            if (this.projects.remove(project)) {
                this.notifySubscribers();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifySubscribers() {
        Set<SPLevoProjectWorkspaceListener> set = this.subscribers;
        synchronized (set) {
            for (SPLevoProjectWorkspaceListener subscriber : this.subscribers) {
                subscriber.availableProjectFilesChanged(this);
            }
        }
    }

    private Iterable<IProject> determineSPLevoProjects() {
        return SPLevoProjectUtil.findAllSPLevoProjectsInWorkspace((boolean)true);
    }
}

