/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.ui.commons.tooltip;

import com.google.common.base.Strings;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.window.DefaultToolTip;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TreeItem;

public abstract class TreeViewerToolTip
extends DefaultToolTip {
    private final TreeViewer viewer;
    private final Class<?>[] relevantItemTypes;

    public TreeViewerToolTip(TreeViewer viewer, Class<?> ... relevantItemTypes) {
        super((Control)viewer.getTree());
        this.viewer = viewer;
        this.relevantItemTypes = relevantItemTypes;
        this.setShift(new Point(12, 0));
        this.setRespectDisplayBounds(true);
        this.setRespectMonitorBounds(true);
    }

    protected boolean shouldCreateToolTip(Event event) {
        if (this.getItem(event, this.relevantItemTypes) == null) {
            return false;
        }
        return super.shouldCreateToolTip(event);
    }

    protected Composite createToolTipContentArea(Event event, Composite parent) {
        String text = this.getText(event);
        String heading = this.getToolTipHeading(event);
        Composite container = this.setDefaultLayout(new Composite(parent, 0), event);
        container.setLayout((Layout)new GridLayout());
        StyledText label = this.setDefaultLayout(new StyledText(container, 64), event);
        String labelText = text;
        StyleRange headingStyling = new StyleRange();
        if (!Strings.isNullOrEmpty((String)heading)) {
            labelText = String.format("%s\n%s", heading, labelText);
            headingStyling.start = 0;
            headingStyling.length = heading.length();
            headingStyling.fontStyle = 1;
        }
        label.setText(labelText);
        label.setStyleRange(headingStyling);
        Point prefSize = label.computeSize(-1, -1, true);
        int prefWidth = Math.min(500, prefSize.x);
        GridDataFactory.fillDefaults().hint(prefWidth, -1).applyTo((Control)label);
        return container;
    }

    protected abstract String getToolTipHeading(Event var1);

    protected <T> T getCorrectlyTypedItem(Event event, Class<T> clazz) {
        Object item = this.getItem(event, new Class[]{clazz});
        if (item == null) {
            return null;
        }
        return (T)item;
    }

    private Object getItem(Event event, Class<?>[] classes) {
        TreeItem item = this.getTreeItemFromEvent(event);
        if (item == null || item.getData() == null) {
            return null;
        }
        Class<?>[] classArray = classes;
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> c = classArray[n2];
            if (c.isAssignableFrom(item.getData().getClass())) {
                return item.getData();
            }
            ++n2;
        }
        return null;
    }

    private TreeItem getTreeItemFromEvent(Event event) {
        return this.viewer.getTree().getItem(new Point(event.x, event.y));
    }

    private <T extends Control> T setDefaultLayout(T control, Event event) {
        control.setBackground(this.getBackgroundColor(event));
        control.setForeground(this.getForegroundColor(event));
        control.setFont(this.getFont(event));
        return control;
    }
}

