/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.ui.vpexplorer.explorer;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.splevo.ui.vpexplorer.Activator;
import org.splevo.ui.vpexplorer.explorer.VPExplorer;
import org.splevo.ui.vpexplorer.featureoutline.FeatureOutlineView;
import org.splevo.ui.vpexplorer.linking.ILinkableNavigator;
import org.splevo.vpm.variability.VariationPoint;
import org.splevo.vpm.variability.VariationPointModel;

public class ExplorerMediator
implements ISelectionChangedListener {
    private static Logger logger = Logger.getLogger(ExplorerMediator.class);
    private VPExplorer vpExplorer;
    private FeatureOutlineView vpGroupingExplorer;

    public void registerVPExplorer(VPExplorer vpExplorer) {
        this.vpExplorer = vpExplorer;
    }

    public void deregisterVPExplorer() {
        this.vpExplorer = null;
    }

    public void registerVPGroupingExplorer(FeatureOutlineView groupingExplorer) {
        this.vpGroupingExplorer = groupingExplorer;
    }

    public void deregisterVPGRoupingExplorer() {
        this.vpGroupingExplorer = null;
    }

    public void vpmAssigned() {
        if (this.vpExplorer != null) {
            if (this.vpGroupingExplorer != null) {
                this.vpGroupingExplorer.setVPM(this.vpExplorer.getVpExplorerContent().getVpm());
            } else {
                this.openVPGroupingExplorer(this.vpExplorer.getVpExplorerContent().getVpm());
            }
        } else {
            logger.warn((Object)"Tried to distribute VP Explorer Content without registered VP Explorer");
        }
    }

    private void openVPGroupingExplorer(final VariationPointModel vpm) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    IWorkbenchWindow activeWorkbench = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    IViewPart viewPart = activeWorkbench.getActivePage().showView("org.splevo.ui.vpexplorer.featureoutline");
                    FeatureOutlineView explorer = (FeatureOutlineView)viewPart;
                    if (vpm != null) {
                        explorer.setVPM(vpm);
                    }
                }
                catch (PartInitException e) {
                    logger.error((Object)"Could not create the VP grouping explorer view", (Throwable)e);
                }
            }
        });
    }

    public VariationPointModel getCurrentVPM() {
        if (this.vpGroupingExplorer != null && this.vpGroupingExplorer.getVpExplorerContent() != null) {
            return this.vpGroupingExplorer.getVpExplorerContent().getVpm();
        }
        if (this.vpExplorer != null && this.vpExplorer.getVpExplorerContent() != null) {
            return this.vpExplorer.getVpExplorerContent().getVpm();
        }
        return null;
    }

    private Iterable<Object> preprocessSelectedObjects(Iterable<Object> selectedObjects) {
        final VariationPointModel currentVPM = this.getCurrentVPM();
        if (currentVPM == null) {
            return selectedObjects;
        }
        Iterable selectedVPs = Iterables.filter(selectedObjects, VariationPoint.class);
        Iterable mappedVPs = Iterables.transform((Iterable)selectedVPs, (Function)new Function<VariationPoint, VariationPoint>(){

            private VariationPointModel getParentVPM(VariationPoint vpm) {
                EObject parent = vpm.eContainer();
                while (parent != null && !(parent instanceof VariationPointModel)) {
                    parent = parent.eContainer();
                }
                return (VariationPointModel)parent;
            }

            public VariationPoint apply(VariationPoint arg0) {
                if (this.getParentVPM(arg0) == currentVPM) {
                    return arg0;
                }
                Optional<VariationPoint> vp = ILinkableNavigator.ILinkableNavigatorHelper.find(arg0, currentVPM);
                if (vp.isPresent()) {
                    return (VariationPoint)vp.get();
                }
                return null;
            }
        });
        Iterable selectedAndAvailableVPs = Iterables.filter((Iterable)mappedVPs, (Predicate)Predicates.notNull());
        Sets.SetView noVPObjects = Sets.difference((Set)Sets.newHashSet(selectedObjects), (Set)Sets.newHashSet((Iterable)selectedVPs));
        return Iterables.concat((Iterable)noVPObjects, (Iterable)selectedAndAvailableVPs);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (!(event.getSelection() instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        Iterable<Object> selectedObjects = this.preprocessSelectedObjects(Lists.newArrayList((Iterator)selection.iterator()));
        if (this.vpExplorer != null && event.getSource() != this.vpExplorer.getCommonViewer()) {
            this.vpExplorer.elementSelectedInOtherNavigator(selectedObjects);
        }
        if (this.vpGroupingExplorer != null && event.getSource() != this.vpGroupingExplorer.getCommonViewer()) {
            this.vpGroupingExplorer.elementSelectedInOtherNavigator(selectedObjects);
        }
    }

    public static ExplorerMediator getInstance() {
        return Activator.EXPLORER_MEDIATOR;
    }
}

