/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.ui.vpexplorer.explorer;

import com.google.common.collect.Iterables;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.navigator.CommonNavigator;
import org.splevo.project.SPLevoProject;
import org.splevo.project.VPMModelReference;
import org.splevo.ui.commons.tooltip.CustomizableDescriptionHavingTreeViewerToolTip;
import org.splevo.ui.vpexplorer.Activator;
import org.splevo.ui.vpexplorer.explorer.ExplorerMediator;
import org.splevo.ui.vpexplorer.explorer.LoadVPMCompositeHandler;
import org.splevo.ui.vpexplorer.explorer.SwitchBackVPM;
import org.splevo.ui.vpexplorer.explorer.VPExplorerContent;
import org.splevo.ui.vpexplorer.explorer.actions.ExpandAllAction;
import org.splevo.ui.vpexplorer.explorer.actions.SelectVisibleAction;
import org.splevo.ui.vpexplorer.linking.ILinkableNavigator;
import org.splevo.ui.vpexplorer.util.VPMUIUtil;
import org.splevo.vpm.variability.VariationPoint;
import org.splevo.vpm.variability.VariationPointModel;

public class VPExplorer
extends CommonNavigator
implements ILinkableNavigator,
LoadVPMCompositeHandler.VPMLoader {
    public static final String VIEW_ID = "org.splevo.ui.vpexplorer";
    private static final String CONTEXT_ID = "org.splevo.ui.vpexplorer.context";
    private static final Logger LOGGER = Logger.getLogger(VPExplorer.class);
    private VPExplorerContent vpExplorerContent;
    private SPLevoProject splevoProject;
    private ExplorerMediator mediator;
    private final LoadVPMCompositeHandler loadVPMCompositeHandler = new LoadVPMCompositeHandler(this);
    private DisplayedCompositeSwitcher displayedCompositeSwitcher;
    private boolean showGrouping = false;

    public VPExplorer() {
        this.vpExplorerContent = new VPExplorerContent(this);
        this.mediator = Activator.EXPLORER_MEDIATOR;
        this.mediator.registerVPExplorer(this);
    }

    protected IAdaptable getInitialInput() {
        this.getCommonViewer().refresh();
        return this.vpExplorerContent;
    }

    public VPExplorerContent getVpExplorerContent() {
        return this.vpExplorerContent;
    }

    public void createPartControl(Composite parent) {
        Composite intermediateParent = new Composite(parent, 0);
        intermediateParent.setLayoutData((Object)new GridData(1808));
        StackLayout layout = new StackLayout();
        intermediateParent.setLayout((Layout)layout);
        Composite vpmLoadingComposite = this.loadVPMCompositeHandler.createControl(intermediateParent);
        layout.topControl = vpmLoadingComposite;
        this.displayedCompositeSwitcher = new DisplayedCompositeSwitcher(layout, intermediateParent);
        super.createPartControl(intermediateParent);
        new CustomizableDescriptionHavingTreeViewerToolTip((TreeViewer)this.getCommonViewer());
        IActionBars actionBars = this.getViewSite().getActionBars();
        IToolBarManager toolBar = actionBars.getToolBarManager();
        if (toolBar.getItems().length > 0) {
            toolBar.insertBefore(toolBar.getItems()[0].getId(), (IAction)new ExpandAllAction(this));
            toolBar.insertBefore(toolBar.getItems()[0].getId(), (IAction)new ExpandAllAction(this, ExpandAllAction.MODE.VARIATIONPOINT));
            toolBar.insertBefore(toolBar.getItems()[0].getId(), (IAction)new SelectVisibleAction(this));
            toolBar.insertBefore(toolBar.getItems()[0].getId(), (IAction)new SwitchBackVPM(this));
        } else {
            toolBar.add((IAction)new ExpandAllAction(this));
            toolBar.add((IAction)new ExpandAllAction(this, ExpandAllAction.MODE.VARIATIONPOINT));
            toolBar.add((IAction)new SelectVisibleAction(this));
            toolBar.add((IAction)new SwitchBackVPM(this));
        }
        this.getCommonViewer().addSelectionChangedListener((ISelectionChangedListener)this.mediator);
        this.getCommonViewer().addTreeListener(new ITreeViewerListener(){

            public void treeCollapsed(TreeExpansionEvent event) {
            }

            public void treeExpanded(TreeExpansionEvent event) {
                if (this != null && event.getSource() == VPExplorer.this.getCommonViewer()) {
                    VPExplorer.this.expandTree(event.getElement());
                }
            }
        });
        this.getCommonViewer().addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                if (!(event.getSelection() instanceof IStructuredSelection)) {
                    return;
                }
                Object[] selection = ((IStructuredSelection)event.getSelection()).toArray();
                if (selection.length <= 0) {
                    return;
                }
                if (!VPExplorer.this.getCommonViewer().getExpandedState(selection[0])) {
                    return;
                }
                if (this != null && event.getSource() == VPExplorer.this.getCommonViewer()) {
                    VPExplorer.this.expandTree(selection[0]);
                }
            }
        });
        FocusListener focusListener = new FocusListener(){
            private IContextActivation activation;

            public void focusGained(FocusEvent e) {
                this.activation = ((IContextService)PlatformUI.getWorkbench().getService(IContextService.class)).activateContext(VPExplorer.CONTEXT_ID);
            }

            public void focusLost(FocusEvent e) {
                ((IContextService)PlatformUI.getWorkbench().getService(IContextService.class)).deactivateContext(this.activation);
            }
        };
        this.getCommonViewer().getTree().addFocusListener(focusListener);
    }

    @Override
    public void loadVPM(SPLevoProject project, VPMModelReference vpmReference) {
        LOGGER.info((Object)"Loading VPM");
        VPMUIUtil.openVPExplorer(project, vpmReference);
    }

    public void toggleShowGrouping() {
        this.showGrouping = !this.showGrouping;
        this.getCommonViewer().refresh();
    }

    public boolean getShowGrouping() {
        return this.showGrouping;
    }

    public void setVPM(VariationPointModel vpm, SPLevoProject splevoProject) {
        this.vpExplorerContent.setVpm(vpm);
        this.splevoProject = splevoProject;
        this.mediator.vpmAssigned();
        this.displayedCompositeSwitcher.switchToVPMTree();
    }

    public SPLevoProject getSPLevoProject() {
        return this.splevoProject;
    }

    public void dispose() {
        this.mediator.deregisterVPExplorer();
        this.loadVPMCompositeHandler.disable();
        super.dispose();
    }

    @Override
    public void elementSelectedInOtherNavigator(Iterable<Object> selectedElement) {
        if (!this.isLinkingEnabled()) {
            return;
        }
        Iterable vps = Iterables.filter(selectedElement, VariationPoint.class);
        ITreeContentProvider contentProvider = this.getNavigatorContentService().createCommonContentProvider();
        ILinkableNavigator.ILinkableNavigatorHelper.expandToObject((TreeViewer)this.getCommonViewer(), contentProvider, vps);
    }

    private void expandTree(final Object selectedElement) {
        this.getCommonViewer().getControl().getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                ITreeContentProvider contentProvider = VPExplorer.this.getNavigatorContentService().createCommonContentProvider();
                Object[] elements = contentProvider.getChildren(selectedElement);
                while (elements.length == 1) {
                    elements = contentProvider.getChildren(elements[0]);
                }
                if (elements.length == 0) {
                    return;
                }
                VPExplorer.this.getCommonViewer().refresh();
                VPExplorer.this.getCommonViewer().expandToLevel(elements[0], 0);
            }
        });
    }

    private class DisplayedCompositeSwitcher {
        private final StackLayout layout;
        private final Composite parentToRefresh;

        public DisplayedCompositeSwitcher(StackLayout layout, Composite parentToRefresh) {
            this.layout = layout;
            this.parentToRefresh = parentToRefresh;
        }

        public void switchToVPMTree() {
            this.layout.topControl = VPExplorer.this.getCommonViewer().getControl();
            this.parentToRefresh.layout(true);
            VPExplorer.this.loadVPMCompositeHandler.disable();
        }
    }
}

