/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.ui.vpexplorer.explorer.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.navigator.CommonViewer;
import org.splevo.ui.vpexplorer.Activator;
import org.splevo.ui.vpexplorer.explorer.VPExplorer;
import org.splevo.vpm.variability.VariationPoint;

public class SelectVisibleAction
extends Action {
    private static final String ICON = "icons/VariationPoint_select.gif";
    private final VPExplorer explorer;

    public SelectVisibleAction(VPExplorer explorer) {
        super("Expand visible VariationPoints", 1);
        this.explorer = explorer;
        this.setToolTipText("Select all variation points currently visible (expanded and not filtered)");
        this.setImageDescriptor(Activator.getImageDescriptor(ICON));
    }

    public void run() {
        CommonViewer viewer = this.explorer.getCommonViewer();
        Tree tree = viewer.getTree();
        tree.deselectAll();
        TreeItem[] items = tree.getItems();
        this.selectItems(tree, items);
    }

    private void selectItems(Tree tree, TreeItem[] items) {
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            Object dataItem = item.getData();
            if (dataItem instanceof VariationPoint) {
                tree.select(item);
            } else if (item.getExpanded()) {
                TreeItem[] subItems = item.getItems();
                this.selectItems(tree, subItems);
            }
            ++n2;
        }
    }

    public String getId() {
        return "org.splevo.ui.vpexplorer.explorer.actions.SelectVisbleVPs";
    }
}

