/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.ui.vpexplorer.featureoutline.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.ui.navigator.CommonViewer;
import org.splevo.ui.vpexplorer.Activator;
import org.splevo.ui.vpexplorer.featureoutline.FeatureOutlineView;
import org.splevo.vpm.variability.VariationPoint;
import org.splevo.vpm.variability.VariationPointGroup;

public class NoVariabilityMechanismAction
extends Action {
    private static final String ICON = "icons/filter.png";
    private FeatureOutlineView feature;
    private static ViewerFilter filter = new ViewerFilter(){

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof VariationPoint && ((VariationPoint)element).getVariabilityMechanism() == null) {
                return true;
            }
            if (element instanceof VariationPointGroup) {
                ITreeContentProvider contentProvider = (ITreeContentProvider)((CommonViewer)viewer).getContentProvider();
                Object[] objectArray = contentProvider.getChildren(element);
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object child = objectArray[n2];
                    if (this.select(viewer, element, child)) {
                        return true;
                    }
                    ++n2;
                }
            }
            return false;
        }
    };

    public NoVariabilityMechanismAction(FeatureOutlineView feature) {
        super("Show variation points with no variability mechanism", 2);
        this.feature = feature;
        this.setImageDescriptor(Activator.getImageDescriptor(ICON));
    }

    public void run() {
        if (this.isChecked()) {
            this.feature.getCommonViewer().addFilter(filter);
        } else {
            this.feature.getCommonViewer().removeFilter(filter);
        }
    }
}

