/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.ui.vpexplorer.handler.characteristics.variabilitymechanism;

import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.splevo.refactoring.VariabilityRefactoring;
import org.splevo.refactoring.VariabilityRefactoringRegistry;
import org.splevo.ui.vpexplorer.handler.characteristics.variabilitymechanism.SetVariabilityMechanism;

public class VariabilityMechanismContribution
extends ContributionItem {
    private static List<VariabilityRefactoring> elements;
    private static Logger logger;
    private static final String DATA_KEY = "DATAKEY";
    private VariabilityRefactoring mechanism;

    static {
        logger = Logger.getLogger(VariabilityMechanismContribution.class);
        elements = VariabilityRefactoringRegistry.getInstance().getElements();
    }

    public VariabilityMechanismContribution() {
    }

    public VariabilityMechanismContribution(String id) {
        super(id);
    }

    public void fill(Menu menu, int index) {
        int i = 0;
        while (i < elements.size()) {
            MenuItem menuItem = new MenuItem(menu, 32, index);
            menuItem.setText(elements.get(i).getVariabilityMechanism().getName());
            menuItem.setData(DATA_KEY, (Object)elements.get(i));
            menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (!(e.getSource() instanceof MenuItem)) {
                        return;
                    }
                    MenuItem item = (MenuItem)e.getSource();
                    if (!(item.getData(VariabilityMechanismContribution.DATA_KEY) instanceof VariabilityRefactoring)) {
                        return;
                    }
                    VariabilityMechanismContribution.this.mechanism = (VariabilityRefactoring)item.getData(VariabilityMechanismContribution.DATA_KEY);
                    IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    ISelection selection = window.getActivePage().getSelection();
                    SetVariabilityMechanism setMechanism = new SetVariabilityMechanism(VariabilityMechanismContribution.this.mechanism);
                    try {
                        setMechanism.execute(selection);
                    }
                    catch (ExecutionException e1) {
                        logger.error((Object)("Failed to set mechanism: " + (Object)((Object)e1)));
                    }
                }
            });
            ++i;
        }
    }
}

