/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.ui.vpexplorer.explorer;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.splevo.project.SPLevoProject;
import org.splevo.project.VPMModelReference;
import org.splevo.project.utils.SPLevoProjectUtil;

public class LoadVPMCompositeHandler {
    private static final Logger LOGGER = Logger.getLogger(LoadVPMCompositeHandler.class);
    private final IResourceChangeListener projecListener = this.createProjectOpenCloseListener();
    private final ILabelProvider labelProvider = this.createLabelProvider();
    private final IStructuredContentProvider contentProvider = this.createContentProvider();
    private final VPMLoader vpmLoader;
    private ComboViewer comboViewer;

    public LoadVPMCompositeHandler(VPMLoader vpmLoader) {
        this.vpmLoader = vpmLoader;
    }

    public void disable() {
        this.unregisterForProjectOpenCloseEvents();
    }

    public Composite createControl(Composite parent) {
        this.registerForProjectOpenCloseEvents();
        Composite emptyViewPane = new Composite(parent, 0);
        emptyViewPane.setLayoutData((Object)new GridData(1808));
        emptyViewPane.setLayout((Layout)new GridLayout(2, false));
        Label explanationLabel = new Label(emptyViewPane, 64);
        this.comboViewer = new ComboViewer(emptyViewPane, 12);
        final Button vpmLoadingButton = new Button(emptyViewPane, 0);
        explanationLabel.setText("There is no VPM loaded. You can select a VPM based on the open consolidation projects located in your workspace.");
        explanationLabel.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 2, 1));
        this.comboViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.comboViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.comboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                vpmLoadingButton.setEnabled(true);
            }
        });
        this.comboViewer.getCombo().setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.refreshComboViewerInput();
        vpmLoadingButton.setText("Load");
        vpmLoadingButton.setEnabled(false);
        vpmLoadingButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!(LoadVPMCompositeHandler.this.comboViewer.getSelection() instanceof IStructuredSelection)) {
                    LOGGER.warn((Object)"No structured selection returned from combo box.");
                    return;
                }
                IStructuredSelection cvSelection = (IStructuredSelection)LoadVPMCompositeHandler.this.comboViewer.getSelection();
                if (!(cvSelection.getFirstElement() instanceof VPMLoadingInformation)) {
                    LOGGER.warn((Object)"The selected value in the combo box is not correctly typed.");
                    vpmLoadingButton.setEnabled(false);
                    return;
                }
                VPMLoadingInformation vpmInformation = (VPMLoadingInformation)cvSelection.getFirstElement();
                LoadVPMCompositeHandler.this.loadVPM(vpmInformation.getProject(), vpmInformation.getVPMReference());
            }
        });
        return emptyViewPane;
    }

    private IResourceChangeListener createProjectOpenCloseListener() {
        return new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                if (event.getType() == 2) {
                    LoadVPMCompositeHandler.this.projectClosed((IProject)event.getResource());
                }
                if (event.getType() == 1) {
                    LoadVPMCompositeHandler.this.projectClosed((IProject)event.getResource());
                    try {
                        event.getDelta().accept(new IResourceDeltaVisitor(){

                            public boolean visit(IResourceDelta delta) throws CoreException {
                                if (delta.getResource() instanceof IWorkspaceRoot) {
                                    return true;
                                }
                                if ((delta.getFlags() & 0x4000) != 0 && delta.getResource() instanceof IProject) {
                                    LoadVPMCompositeHandler.this.projectOpened((IProject)delta.getResource());
                                }
                                return false;
                            }
                        });
                    }
                    catch (CoreException e) {
                        LOGGER.warn((Object)"Error processing a resource change. The VPM loading composite might not be up to date anymore.", (Throwable)e);
                    }
                }
            }
        };
    }

    private IStructuredContentProvider createContentProvider() {
        return new IStructuredContentProvider(){
            private VPMLoadingInformationProvider provider;

            public void inputChanged(final Viewer viewer, Object oldInput, Object newInput) {
                if (newInput == null) {
                    return;
                }
                if (!(newInput instanceof VPMLoadingInformationProvider)) {
                    LOGGER.warn((Object)String.format("The given input is of type %s instead of %s.", newInput.getClass().getSimpleName(), VPMLoadingInformationProvider.class.getSimpleName()));
                    return;
                }
                this.provider = (VPMLoadingInformationProvider)newInput;
                viewer.getControl().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        viewer.refresh();
                    }
                });
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                if (this.provider != null) {
                    return this.provider.getElements();
                }
                return new Object[0];
            }
        };
    }

    private ILabelProvider createLabelProvider() {
        return new LabelProvider();
    }

    private void registerForProjectOpenCloseEvents() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.projecListener);
    }

    private void unregisterForProjectOpenCloseEvents() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.projecListener);
    }

    private void projectOpened(IProject resource) {
        this.refreshComboViewerInput();
    }

    private void projectClosed(IProject resource) {
        this.refreshComboViewerInput();
    }

    private void refreshComboViewerInput() {
        this.comboViewer.getControl().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                LoadVPMCompositeHandler.this.comboViewer.setInput((Object)new VPMLoadingInformationProvider());
            }
        });
    }

    private void loadVPM(SPLevoProject project, VPMModelReference vpmReference) {
        this.vpmLoader.loadVPM(project, vpmReference);
    }

    public static interface VPMLoader {
        public void loadVPM(SPLevoProject var1, VPMModelReference var2);
    }

    private static class VPMLoadingInformation {
        private final SPLevoProject project;
        private final VPMModelReference vpmReference;

        public VPMLoadingInformation(SPLevoProject project, VPMModelReference vpmReference) {
            this.project = project;
            this.vpmReference = vpmReference;
        }

        public SPLevoProject getProject() {
            return this.project;
        }

        public VPMModelReference getVPMReference() {
            return this.vpmReference;
        }

        public String toString() {
            return String.format("%s: %s", this.project.getName(), FilenameUtils.getName((String)this.vpmReference.getPath()));
        }
    }

    private static class VPMLoadingInformationProvider {
        private VPMLoadingInformationProvider() {
        }

        public Object[] getElements() {
            ArrayList<VPMLoadingInformation> elements = new ArrayList<VPMLoadingInformation>();
            Iterable projects = SPLevoProjectUtil.findAllSPLevoProjectsInWorkspace((boolean)true);
            Iterable projectFiles = Iterables.filter((Iterable)Iterables.transform((Iterable)projects, (Function)new Function<IProject, IFile>(){

                public IFile apply(IProject input) {
                    return (IFile)SPLevoProjectUtil.findSPLevoProjectFile((IProject)input).orNull();
                }
            }), (Predicate)Predicates.notNull());
            for (IFile projectFile : projectFiles) {
                try {
                    SPLevoProject project = SPLevoProjectUtil.loadSPLevoProjectModel((IFile)projectFile);
                    VPMModelReference vpmReference = (VPMModelReference)Iterables.getLast((Iterable)project.getVpmModelReferences());
                    elements.add(new VPMLoadingInformation(project, vpmReference));
                }
                catch (NoSuchElementException e) {
                }
                catch (IOException e) {
                    LOGGER.warn((Object)"Error loading the SPLevo project.", (Throwable)e);
                }
            }
            return elements.toArray();
        }
    }
}

