/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.ui.vpexplorer.explorer;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.splevo.project.VPMModelReference;
import org.splevo.ui.vpexplorer.explorer.VPExplorer;
import org.splevo.ui.vpexplorer.util.VPMUIUtil;

public class SwitchBackVPM
extends Action {
    private static final String ACTION_TEXT = "Switch Back VPM";
    private final VPExplorer vpexplorer;

    public SwitchBackVPM(VPExplorer vpexplorer) {
        super(ACTION_TEXT, 4);
        this.vpexplorer = vpexplorer;
    }

    public ImageDescriptor getImageDescriptor() {
        return PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_UNDO");
    }

    public IMenuCreator getMenuCreator() {
        IMenuCreator menuCreator = new IMenuCreator(){

            public void dispose() {
            }

            public Menu getMenu(Control parent) {
                return this.createMenuManager().createContextMenu(parent);
            }

            public Menu getMenu(Menu parent) {
                return null;
            }

            private MenuManager createMenuManager() {
                MenuManager manager = new MenuManager();
                manager.addMenuListener(new IMenuListener(){

                    public void menuAboutToShow(IMenuManager manager) {
                        if (SwitchBackVPM.this.vpexplorer.getSPLevoProject() != null && SwitchBackVPM.this.vpexplorer.getSPLevoProject() != null && SwitchBackVPM.this.vpexplorer.getSPLevoProject().getVpmModelReferences().size() > 0) {
                            for (VPMModelReference reference : Lists.reverse((List)SwitchBackVPM.this.vpexplorer.getSPLevoProject().getVpmModelReferences())) {
                                manager.add((IAction)new VPMRollbackMenuAction(reference));
                            }
                        }
                    }
                });
                return manager;
            }
        };
        return menuCreator;
    }

    private class VPMRollbackMenuAction
    extends Action {
        private final VPMModelReference vpmReference;

        public VPMRollbackMenuAction(VPMModelReference reference) {
            super(FilenameUtils.getBaseName((String)reference.getPath()));
            this.vpmReference = reference;
        }

        public void runWithEvent(Event event) {
            Shell shell = event.widget.getDisplay().getActiveShell();
            boolean confirmed = MessageDialog.openQuestion((Shell)shell, (String)"Switch Back VPM Version", (String)String.format("You want to switch back to %s, which removes all later versions. Do you want to continue?", this.getText()));
            if (confirmed) {
                VPMUIUtil.switchBackVPMVersion(SwitchBackVPM.this.vpexplorer.getSPLevoProject(), this.vpmReference);
            }
        }
    }
}

