/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.ui.vpexplorer.util;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.splevo.project.SPLevoProject;
import org.splevo.project.VPMModelReference;
import org.splevo.ui.commons.util.WorkspaceUtil;
import org.splevo.ui.vpexplorer.util.VPMUIUtil;

public class SwitchBackVPMJob
extends Job {
    private static final Logger LOGGER = Logger.getLogger(SwitchBackVPMJob.class);
    private final SPLevoProject splevoProject;
    private final VPMModelReference vpmReference;

    public SwitchBackVPMJob(SPLevoProject splevoProject, VPMModelReference vpmReference) {
        super("Switch Back VPM Version");
        this.splevoProject = splevoProject;
        this.vpmReference = vpmReference;
    }

    protected IStatus run(IProgressMonitor monitor) {
        monitor.beginTask("Switch Back VPM Version", -1);
        monitor.subTask("Remove obsolete VPMs from project");
        Iterable filteredModels = Iterables.filter((Iterable)this.splevoProject.getVpmModelReferences(), (Predicate)new Predicate<VPMModelReference>(){
            private boolean afterSelected = false;

            public boolean apply(VPMModelReference arg0) {
                if (this.afterSelected) {
                    return true;
                }
                this.afterSelected = arg0.equals(SwitchBackVPMJob.this.vpmReference);
                return false;
            }
        });
        ArrayList obsoleteModels = Lists.newArrayList((Iterable)filteredModels);
        for (VPMModelReference reference : obsoleteModels) {
            new File(WorkspaceUtil.getAbsoluteFromWorkspaceRelativePath((String)reference.getPath())).delete();
        }
        this.splevoProject.getVpmModelReferences().removeAll((Collection)obsoleteModels);
        monitor.subTask("Save project");
        try {
            this.splevoProject.eResource().save(Collections.EMPTY_MAP);
        }
        catch (IOException e) {
            LOGGER.error((Object)"Unable to save project after removing VPMs.", (Throwable)e);
            return new Status(4, "Error", "We could not save the project after removing obsolete variation point models.");
        }
        monitor.subTask("Shedule loading of the new VPM");
        VPMUIUtil.openVPExplorer(this.splevoProject, this.vpmReference);
        monitor.done();
        return Status.OK_STATUS;
    }
}

