/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.ui.vpexplorer.linking;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.util.LinkedList;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.TreeItem;
import org.splevo.vpm.variability.VariationPoint;
import org.splevo.vpm.variability.VariationPointGroup;
import org.splevo.vpm.variability.VariationPointModel;

public interface ILinkableNavigator {
    public void elementSelectedInOtherNavigator(Iterable<Object> var1);

    public static class ILinkableNavigatorHelper {
        public static void expandToObject(final TreeViewer treeViewer, ITreeContentProvider contentProvider, Iterable<VariationPoint> selectedVPs) {
            if (Iterables.isEmpty(selectedVPs)) {
                return;
            }
            treeViewer.collapseAll();
            for (VariationPoint vp : selectedVPs) {
                ILinkableNavigatorHelper.expandToObject(treeViewer, contentProvider, vp);
            }
            Iterable selection = Iterables.filter((Iterable)Iterables.transform(selectedVPs, (Function)new Function<VariationPoint, TreeItem>(){

                public TreeItem apply(VariationPoint arg0) {
                    return (TreeItem)treeViewer.testFindItem((Object)arg0);
                }
            }), (Predicate)Predicates.notNull());
            treeViewer.getTree().setSelection((TreeItem[])Iterables.toArray((Iterable)selection, TreeItem.class));
        }

        private static void expandToObject(TreeViewer treeViewer, ITreeContentProvider contentProvider, VariationPoint vp) {
            LinkedList<Object> treePathElements = new LinkedList<Object>();
            treePathElements.add(vp);
            Object parent = contentProvider.getParent((Object)vp);
            while (parent != null) {
                treePathElements.add(0, parent);
                parent = contentProvider.getParent(parent);
            }
            TreePath treePath = new TreePath(treePathElements.toArray());
            treeViewer.expandToLevel((Object)treePath, 0);
        }

        public static Optional<VariationPoint> find(VariationPoint variationPoint, VariationPointModel vpm) {
            for (VariationPointGroup vpg : vpm.getVariationPointGroups()) {
                for (VariationPoint vp : vpg.getVariationPoints()) {
                    if (!vp.getId().equals(variationPoint.getId())) continue;
                    return Optional.of((Object)vp);
                }
            }
            return Optional.absent();
        }
    }
}

