/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.ui.vpexplorer.providers;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOCase;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.viewers.TreeNodeContentProvider;
import org.eclipse.ui.PlatformUI;
import org.splevo.commons.emf.FileResourceHandling;
import org.splevo.ui.vpexplorer.explorer.VPExplorer;
import org.splevo.ui.vpexplorer.explorer.VPExplorerContent;
import org.splevo.ui.vpexplorer.providers.FileWrapper;
import org.splevo.vpm.software.SoftwareElement;
import org.splevo.vpm.variability.Variant;
import org.splevo.vpm.variability.VariationPoint;
import org.splevo.vpm.variability.VariationPointGroup;
import org.splevo.vpm.variability.VariationPointModel;

public class VPExplorerContentProvider
extends TreeNodeContentProvider {
    private static Logger logger = Logger.getLogger(VPExplorerContentProvider.class);
    private static HashMultimap<File, VariationPoint> fileVPIndex = HashMultimap.create();
    private Map<VariationPoint, File> vpFileIndex = Maps.newLinkedHashMap();
    private HashMultimap<File, File> subFileIndex = HashMultimap.create();
    private HashMultimap<VariationPointGroup, File> groupFileIndex = HashMultimap.create();
    private Set<File> rootFiles = new HashSet<File>();

    public static Set<VariationPoint> getVPInFile(File file) {
        return fileVPIndex.get((Object)file);
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof VPExplorerContent) {
            return this.getChildren((VPExplorerContent)((Object)parentElement));
        }
        if (parentElement instanceof File) {
            return this.getChildren((File)parentElement);
        }
        if (parentElement instanceof FileWrapper) {
            return this.getChildren((FileWrapper)parentElement);
        }
        if (parentElement instanceof VariationPointModel) {
            return this.getChildren((VariationPointModel)parentElement);
        }
        if (parentElement instanceof VariationPointGroup) {
            return this.getChildren((VariationPointGroup)parentElement);
        }
        if (parentElement instanceof VariationPoint) {
            return this.getChildren((VariationPoint)parentElement);
        }
        if (parentElement instanceof Variant) {
            return this.getChildren((Variant)parentElement);
        }
        if (parentElement instanceof SoftwareElement) {
            return this.getChildren((SoftwareElement)parentElement);
        }
        logger.warn((Object)("Unhandled Parent Element: " + parentElement.getClass().getSimpleName()));
        return new Object[0];
    }

    private Object[] getChildren(VPExplorerContent parentElement) {
        VPExplorer vpexplorer = (VPExplorer)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.splevo.ui.vpexplorer");
        if (parentElement.getVpm() != null) {
            if (vpexplorer.getShowGrouping()) {
                return parentElement.getVpm().getVariationPointGroups().toArray();
            }
            this.indexVariationPointLocations(parentElement);
            return this.rootFiles.toArray();
        }
        return new Object[0];
    }

    private Object[] getChildren(File parentElement) {
        File parentFile = parentElement;
        ArrayList children = Lists.newArrayList();
        children.addAll(fileVPIndex.get((Object)parentFile));
        children.addAll(this.subFileIndex.get((Object)parentFile));
        return children.toArray();
    }

    private Object[] getChildren(FileWrapper parentElement) {
        File parentFile = parentElement.getFile();
        ArrayList children = Lists.newArrayList();
        Collection childFileInGroup = Collections2.filter((Collection)this.subFileIndex.get((Object)parentFile), (Predicate)Predicates.in((Collection)this.groupFileIndex.get((Object)parentElement.getGroup())));
        for (File file : childFileInGroup) {
            children.add(new FileWrapper(parentElement, file, parentElement.getGroup()));
        }
        Collection childVPInGroup = Collections2.filter((Collection)fileVPIndex.get((Object)parentFile), (Predicate)Predicates.in((Collection)parentElement.getGroup().getVariationPoints()));
        children.addAll(childVPInGroup);
        return children.toArray();
    }

    private Object[] getChildren(VariationPointModel parentElement) {
        return parentElement.getVariationPointGroups().toArray();
    }

    private Object[] getChildren(VariationPointGroup parentElement) {
        VPExplorer vpexplorer = (VPExplorer)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.splevo.ui.vpexplorer");
        VariationPointGroup group = parentElement;
        LinkedList<FileWrapper> childFiles = new LinkedList<FileWrapper>();
        if (vpexplorer.getShowGrouping()) {
            Collection files = Collections2.filter(this.rootFiles, (Predicate)Predicates.in((Collection)this.groupFileIndex.get((Object)group)));
            for (File file : files) {
                childFiles.add(new FileWrapper(group, file, group));
            }
            return childFiles.toArray();
        }
        return group.getVariationPoints().toArray();
    }

    private Object[] getChildren(VariationPoint parentElement) {
        return parentElement.getVariants().toArray();
    }

    private Object[] getChildren(Variant parentElement) {
        EList implementingElements = parentElement.getImplementingElements();
        return implementingElements.toArray();
    }

    private Object[] getChildren(SoftwareElement parentElement) {
        return new Object[0];
    }

    public Object getParent(final Object element) {
        if (element instanceof VariationPoint) {
            File parent = this.vpFileIndex.get((VariationPoint)element);
            if (parent != null) {
                return parent;
            }
            Optional corr = Iterables.tryFind(this.vpFileIndex.keySet(), (Predicate)new Predicate<VariationPoint>(){

                public boolean apply(VariationPoint arg0) {
                    return arg0.getId().equals(((VariationPoint)element).getId());
                }
            });
            if (corr.isPresent()) {
                return this.vpFileIndex.get(corr.get());
            }
            return null;
        }
        if (element instanceof Variant) {
            return ((Variant)element).getVariationPoint();
        }
        if (element instanceof SoftwareElement) {
            return ((SoftwareElement)element).eContainer();
        }
        if (element instanceof File) {
            if (this.rootFiles.contains(element)) {
                return null;
            }
            return ((File)element).getParentFile();
        }
        if (element instanceof FileWrapper) {
            if (this.rootFiles.contains(((FileWrapper)element).getFile())) {
                return null;
            }
            return ((FileWrapper)element).getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void indexVariationPointLocations(VPExplorerContent vpContent) {
        this.clearIndexes();
        workspacePath = this.getNormalizedWorkspacePath();
        vpGroups = vpContent.getVpm().getVariationPointGroups();
        for (VariationPointGroup vpGroup : vpGroups) {
            vps = vpGroup.getVariationPoints();
            for (VariationPoint vp : vps) {
                locationElement = vp.getLocation().getWrappedElement();
                realSourceFile = FileResourceHandling.getPhysicalFilePath((Resource)locationElement.eResource());
                filePath = realSourceFile.getAbsolutePath();
                sourceFile = new VPExplorerContentFileWithChildReference(filePath, new Function<VPExplorerContentFileWithChildReference, Object[]>(){

                    public Object[] apply(VPExplorerContentFileWithChildReference arg0) {
                        return VPExplorerContentProvider.this.getChildren(arg0);
                    }
                });
                this.vpFileIndex.put(vp, sourceFile);
                VPExplorerContentProvider.fileVPIndex.put((Object)sourceFile, (Object)vp);
                this.groupFileIndex.put((Object)vpGroup, (Object)sourceFile);
                parentFile = sourceFile.getParentFile();
                childFile /* !! */  = sourceFile;
                if (parentFile != null) ** GOTO lbl30
                this.rootFiles.add(sourceFile);
                continue;
                while (!(isWorkspaceRoot = this.isWorkspaceRoot(workspacePath, parentFile))) {
                    this.subFileIndex.get((Object)parentFile).add(childFile /* !! */ );
                    this.groupFileIndex.put((Object)vpGroup, (Object)childFile /* !! */ );
                    childFile /* !! */  = parentFile;
                    parentFile = parentFile.getParentFile();
lbl30:
                    // 2 sources

                    if (parentFile != null) continue;
                }
                this.rootFiles.add(childFile /* !! */ );
                this.groupFileIndex.put((Object)vpGroup, (Object)childFile /* !! */ );
            }
        }
    }

    private void clearIndexes() {
        fileVPIndex.clear();
        this.rootFiles.clear();
        this.vpFileIndex.clear();
        this.subFileIndex.clear();
        this.groupFileIndex.clear();
    }

    private String getNormalizedWorkspacePath() {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        String workspaceBasePath = root.getLocation().toPortableString();
        workspaceBasePath = FilenameUtils.normalize((String)workspaceBasePath);
        return workspaceBasePath;
    }

    private boolean isWorkspaceRoot(String workspaceBasePath, File parentFile) {
        try {
            String parentPath = parentFile.getCanonicalPath();
            return IOCase.SYSTEM.checkEquals(parentPath, workspaceBasePath);
        }
        catch (IOException e) {
            return false;
        }
    }

    public static class VPExplorerContentFileWithChildReference
    extends File {
        private static final long serialVersionUID = 7988300896390991983L;
        private final Function<VPExplorerContentFileWithChildReference, Object[]> callable;

        public VPExplorerContentFileWithChildReference(File realFile, Function<VPExplorerContentFileWithChildReference, Object[]> getChildrenCallable) {
            super(realFile.toURI());
            this.callable = getChildrenCallable;
        }

        public VPExplorerContentFileWithChildReference(String pathname, Function<VPExplorerContentFileWithChildReference, Object[]> getChildrenCallable) {
            super(pathname);
            this.callable = getChildrenCallable;
        }

        public Object[] getVPMChildren() {
            return (Object[])this.callable.apply((Object)this);
        }

        @Override
        public File getParentFile() {
            File parentFile = super.getParentFile();
            if (parentFile == null) {
                return null;
            }
            return new VPExplorerContentFileWithChildReference(parentFile, this.callable);
        }
    }
}

