/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.ui.wizard.consolidation.tests;

import java.util.Iterator;
import java.util.SortedSet;
import org.eclipse.jdt.core.IPackageFragment;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.splevo.ui.wizard.consolidation.provider.PackagesTreeContentProvider;

public class PackagesTreeContentProviderTest {
    @Test
    public void testGetElements() {
        PackagesTreeContentProvider packagesTreeContentProvider = new PackagesTreeContentProvider();
        IPackageFragment javaPackage1 = (IPackageFragment)Mockito.mock(IPackageFragment.class);
        IPackageFragment javaPackage2 = (IPackageFragment)Mockito.mock(IPackageFragment.class);
        IPackageFragment[] rootPackages = new IPackageFragment[]{javaPackage1, javaPackage2};
        Object[] result = packagesTreeContentProvider.getElements((Object)rootPackages);
        Assert.assertThat((String)"returned root packages", (Object)((IPackageFragment[])result), (Matcher)CoreMatchers.is((Object)rootPackages));
    }

    @Test
    public void testGetChildren() {
        PackagesTreeContentProvider packagesTreeContentProvider = new PackagesTreeContentProvider();
        IPackageFragment parentPackage = (IPackageFragment)Mockito.mock(IPackageFragment.class);
        Mockito.when((Object)parentPackage.getElementName()).thenReturn((Object)"org.splevo");
        IPackageFragment javaPackage1 = (IPackageFragment)Mockito.mock(IPackageFragment.class);
        Mockito.when((Object)javaPackage1.getElementName()).thenReturn((Object)"org.splevo.wizard");
        IPackageFragment javaPackage2 = (IPackageFragment)Mockito.mock(IPackageFragment.class);
        Mockito.when((Object)javaPackage2.getElementName()).thenReturn((Object)"org.splevo.test");
        SortedSet javaPackages = (SortedSet)Mockito.mock(SortedSet.class);
        Iterator iterator = (Iterator)Mockito.mock(Iterator.class);
        Mockito.when(javaPackages.iterator()).thenReturn((Object)iterator);
        Mockito.when((Object)iterator.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{true, true, false});
        Mockito.when((Object)((IPackageFragment)iterator.next())).thenReturn((Object)parentPackage, (Object[])new IPackageFragment[]{javaPackage1, javaPackage2});
        packagesTreeContentProvider.setJavaPackages(javaPackages);
        Object[] result = packagesTreeContentProvider.getChildren((Object)parentPackage);
        IPackageFragment[] subPackages = new IPackageFragment[]{javaPackage1, javaPackage2};
        Assert.assertThat((String)"returned sub packages", (Object)((IPackageFragment[])result), (Matcher)CoreMatchers.is((Object)subPackages));
    }

    @Test
    public void testGetParent() {
        PackagesTreeContentProvider packagesTreeContentProvider = new PackagesTreeContentProvider();
        IPackageFragment childPackage = (IPackageFragment)Mockito.mock(IPackageFragment.class);
        Mockito.when((Object)childPackage.getElementName()).thenReturn((Object)"org.splevo.wizard");
        IPackageFragment parentPackage = (IPackageFragment)Mockito.mock(IPackageFragment.class);
        Mockito.when((Object)parentPackage.getElementName()).thenReturn((Object)"org.splevo");
        IPackageFragment anotherPackage = (IPackageFragment)Mockito.mock(IPackageFragment.class);
        Mockito.when((Object)anotherPackage.getElementName()).thenReturn((Object)"org.splevo.ui");
        SortedSet javaPackages = (SortedSet)Mockito.mock(SortedSet.class);
        Iterator iterator = (Iterator)Mockito.mock(Iterator.class);
        Mockito.when(javaPackages.iterator()).thenReturn((Object)iterator);
        Mockito.when((Object)iterator.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{true, true, false});
        Mockito.when((Object)((IPackageFragment)iterator.next())).thenReturn((Object)childPackage, (Object[])new IPackageFragment[]{parentPackage, anotherPackage});
        packagesTreeContentProvider.setJavaPackages(javaPackages);
        Assert.assertThat((String)"returned parent package", (Object)((IPackageFragment)packagesTreeContentProvider.getParent((Object)childPackage)), (Matcher)CoreMatchers.is((Object)parentPackage));
    }

    @Test
    public void testHasChildren() {
        PackagesTreeContentProvider packagesTreeContentProvider = new PackagesTreeContentProvider();
        IPackageFragment javaPackage1 = (IPackageFragment)Mockito.mock(IPackageFragment.class);
        Mockito.when((Object)javaPackage1.getElementName()).thenReturn((Object)"org.splevo");
        IPackageFragment javaPackage2 = (IPackageFragment)Mockito.mock(IPackageFragment.class);
        Mockito.when((Object)javaPackage2.getElementName()).thenReturn((Object)"org.splevo.wizard");
        IPackageFragment javaPackage3 = (IPackageFragment)Mockito.mock(IPackageFragment.class);
        Mockito.when((Object)javaPackage3.getElementName()).thenReturn((Object)"org.splevo.test");
        SortedSet javaPackages = (SortedSet)Mockito.mock(SortedSet.class);
        Iterator iterator = (Iterator)Mockito.mock(Iterator.class);
        Mockito.when(javaPackages.iterator()).thenReturn((Object)iterator);
        Mockito.when((Object)iterator.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{true, true, false});
        Mockito.when((Object)((IPackageFragment)iterator.next())).thenReturn((Object)javaPackage1, (Object[])new IPackageFragment[]{javaPackage2, javaPackage3});
        packagesTreeContentProvider.setJavaPackages(javaPackages);
        Assert.assertThat((String)"returned result", (Object)packagesTreeContentProvider.hasChildren((Object)javaPackage1), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((String)"returned result", (Object)packagesTreeContentProvider.hasChildren((Object)javaPackage2), (Matcher)CoreMatchers.is((Object)false));
    }
}

