/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.ui.wizard.consolidation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.splevo.project.SPLevoProject;
import org.splevo.ui.wizard.consolidation.MergedPackage;
import org.splevo.ui.wizard.consolidation.provider.PackageLabelProvider;
import org.splevo.ui.wizard.consolidation.provider.PackagesTreeContentProvider;
import org.splevo.ui.wizard.consolidation.util.PackageUtil;
import org.splevo.ui.wizard.consolidation.util.PackagesComparator;

public class PackageMapWizardPage
extends WizardPage {
    private SPLevoProject projectConfiguration;
    private List<SortedSet<IPackageFragment>> javaPackages;
    private List<IProject> choosenProjects;
    private List<TreeViewer> packagesTreeViewerList;
    private List<Text> packageSelectionTextList;
    private Composite mainComposite;
    private Composite container;
    private List<IPackageFragment> packageFragmentFilterSelection;
    private List<MergedPackage> mergedPackages;
    private TableViewer table;
    private static final String SELECTION_INDEX = "selection";
    private static final String SELECTED_PACKAGE = "package";
    private ViewerFilter selectedFilter = new ViewerFilter(){

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            return !PackageMapWizardPage.this.packageFragmentFilterSelection.contains(element);
        }
    };

    protected PackageMapWizardPage(SPLevoProject projectConfiguration) {
        super("Map Packages Page");
        this.setTitle("Packages ");
        this.setDescription("link packages that should be mapped.");
        this.projectConfiguration = projectConfiguration;
    }

    public void createControl(Composite parent) {
        WizardDialog d = (WizardDialog)this.getWizard().getContainer();
        d.setMinimumPageSize(300, 400);
        this.container = new Composite(parent, 2048);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.horizontalSpacing = 5;
        this.container.setLayout((Layout)gridLayout);
        this.mainComposite = new Composite(this.container, 0);
        this.mainComposite.setLayout((Layout)new GridLayout(1, true));
        this.mainComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.packageFragmentFilterSelection = new ArrayList<IPackageFragment>();
        this.mergedPackages = new ArrayList<MergedPackage>();
        this.setControl((Control)this.container);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.choosenProjects = PackageUtil.getAllChosenProjects(this.projectConfiguration);
            Composite treesComposite = new Composite(this.mainComposite, 4);
            treesComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
            treesComposite.setLayout((Layout)new GridLayout(this.choosenProjects.size(), true));
            this.createPackagesTreeViewerLabels(treesComposite);
            this.createPackagesTreeViewer(treesComposite);
            this.createPackageSelectButtons(treesComposite);
            this.createSelectedPackagesText(treesComposite);
            this.createMergeButton(this.mainComposite);
            this.createMergeList(this.mainComposite);
            this.container.layout();
            this.container.setSize(this.container.computeSize(this.container.getSize().x, this.container.getSize().y, true));
        } else {
            Control[] controlArray = this.mainComposite.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control control = controlArray[n2];
                control.dispose();
                ++n2;
            }
        }
    }

    private void createPackagesTreeViewerLabels(Composite composite) {
        for (IProject project : this.choosenProjects) {
            Label l = new Label(composite, 0);
            l.setText(project.getName());
        }
    }

    private void createPackageSelectButtons(Composite composite) {
        int i = 0;
        while (i < this.choosenProjects.size()) {
            Composite comp = new Composite(composite, 0);
            comp.setLayout((Layout)new GridLayout(2, true));
            GridData gridData1 = new GridData(768);
            gridData1.horizontalAlignment = 2;
            comp.setLayoutData((Object)gridData1);
            GridData gridData = new GridData();
            gridData.horizontalAlignment = 2;
            Button up = new Button(comp, 0);
            up.setLayoutData((Object)gridData);
            up.setText(" \u2191 ");
            up.setData(SELECTION_INDEX, (Object)new Integer(i));
            up.addMouseListener(new MouseListener(){

                public void mouseUp(MouseEvent e) {
                    int index = (Integer)((Button)e.getSource()).getData(PackageMapWizardPage.SELECTION_INDEX);
                    PackageMapWizardPage.this.clearTextSelection((Text)PackageMapWizardPage.this.packageSelectionTextList.get(index));
                    ((TreeViewer)PackageMapWizardPage.this.packagesTreeViewerList.get(index)).refresh();
                    ((TreeViewer)PackageMapWizardPage.this.packagesTreeViewerList.get(index)).expandAll();
                }

                public void mouseDoubleClick(MouseEvent e) {
                }

                public void mouseDown(MouseEvent e) {
                }
            });
            Button down = new Button(comp, 0);
            down.setLayoutData((Object)gridData);
            down.setText(" \u2193 ");
            down.setData(SELECTION_INDEX, (Object)new Integer(i));
            down.addMouseListener(new MouseListener(){

                public void mouseUp(MouseEvent e) {
                    int index = (Integer)((Button)e.getSource()).getData(PackageMapWizardPage.SELECTION_INDEX);
                    PackageMapWizardPage.this.clearTextSelection((Text)PackageMapWizardPage.this.packageSelectionTextList.get(index));
                    Object o = ((IStructuredSelection)((TreeViewer)PackageMapWizardPage.this.packagesTreeViewerList.get(index)).getSelection()).getFirstElement();
                    if (o instanceof IPackageFragment) {
                        IPackageFragment fragment = (IPackageFragment)o;
                        PackageMapWizardPage.this.packageFragmentFilterSelection.add(fragment);
                        ((Text)PackageMapWizardPage.this.packageSelectionTextList.get(index)).setData(PackageMapWizardPage.SELECTED_PACKAGE, (Object)fragment);
                        ((Text)PackageMapWizardPage.this.packageSelectionTextList.get(index)).setText(PackageUtil.getName(fragment));
                    }
                    ((TreeViewer)PackageMapWizardPage.this.packagesTreeViewerList.get(index)).refresh();
                }

                public void mouseDoubleClick(MouseEvent e) {
                }

                public void mouseDown(MouseEvent e) {
                }
            });
            ++i;
        }
    }

    private void clearTextSelection(Text text) {
        IPackageFragment pFragment = (IPackageFragment)text.getData(SELECTED_PACKAGE);
        if (pFragment != null) {
            this.packageFragmentFilterSelection.remove(pFragment);
            text.setData(SELECTED_PACKAGE, null);
            text.setText("");
        }
    }

    private void createSelectedPackagesText(Composite composite) {
        this.packageSelectionTextList = new ArrayList<Text>();
        int i = 0;
        while (i < this.choosenProjects.size()) {
            Text text = new Text(composite, 2048);
            text.setLayoutData((Object)new GridData(768));
            text.setEditable(false);
            this.packageSelectionTextList.add(text);
            ++i;
        }
    }

    private void createMergeButton(Composite composite) {
        Composite comp = new Composite(composite, 0);
        comp.setLayout((Layout)new GridLayout(1, true));
        GridData layoutData = new GridData(768);
        layoutData.horizontalAlignment = 2;
        comp.setLayoutData((Object)layoutData);
        Button button = new Button(comp, 0);
        button.setText(" \u2193 ");
        button.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
                ArrayList<IPackageFragment> fragmentList = new ArrayList<IPackageFragment>();
                int i = 0;
                while (i < PackageMapWizardPage.this.packageSelectionTextList.size()) {
                    IPackageFragment pFragment = (IPackageFragment)((Text)PackageMapWizardPage.this.packageSelectionTextList.get(i)).getData(PackageMapWizardPage.SELECTED_PACKAGE);
                    if (pFragment != null) {
                        fragmentList.add(pFragment);
                    }
                    ++i;
                }
                if (fragmentList.size() == 2) {
                    PackageMapWizardPage.this.mergedPackages.add(new MergedPackage((IPackageFragment)fragmentList.get(0), (IPackageFragment)fragmentList.get(1)));
                    i = 0;
                    while (i < PackageMapWizardPage.this.packageSelectionTextList.size()) {
                        ((Text)PackageMapWizardPage.this.packageSelectionTextList.get(i)).setText("");
                        ((Text)PackageMapWizardPage.this.packageSelectionTextList.get(i)).setData(PackageMapWizardPage.SELECTED_PACKAGE, null);
                        ++i;
                    }
                } else {
                    MessageDialog.openInformation((Shell)PackageMapWizardPage.this.getShell(), (String)"Invalid Input", (String)"there must be 2 packages selected!");
                }
                PackageMapWizardPage.this.table.refresh();
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
    }

    private void createMergeList(Composite composite) {
        Composite comp = new Composite(composite, 0);
        comp.setLayout((Layout)new GridLayout(2, false));
        GridData layoutData = new GridData(768);
        comp.setLayoutData((Object)layoutData);
        Button delete = new Button(comp, 0);
        delete.setText(" X ");
        delete.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
                if (PackageMapWizardPage.this.table.getSelection().isEmpty()) {
                    return;
                }
                for (Object merged : ((StructuredSelection)PackageMapWizardPage.this.table.getSelection()).toList()) {
                    if (!(merged instanceof MergedPackage)) continue;
                    for (IPackageFragment packageFragment : ((MergedPackage)merged).getPackages()) {
                        PackageMapWizardPage.this.packageFragmentFilterSelection.remove(packageFragment);
                    }
                    PackageMapWizardPage.this.mergedPackages.remove(merged);
                }
                PackageMapWizardPage.this.table.getTable().remove(PackageMapWizardPage.this.table.getTable().getSelectionIndices());
                PackageMapWizardPage.this.table.getTable().update();
                for (TreeViewer tree : PackageMapWizardPage.this.packagesTreeViewerList) {
                    tree.refresh();
                }
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.table = new TableViewer(comp, 67584);
        this.table.getTable().setLayoutData((Object)new GridData(768));
        this.table.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.table.setInput(this.mergedPackages);
    }

    private SortedSet<IPackageFragment> getJavaPackages(IProject project) {
        TreeSet<IPackageFragment> javaPackagesSet = new TreeSet<IPackageFragment>(new PackagesComparator());
        try {
            if (project.isNatureEnabled("org.eclipse.jdt.core.javanature")) {
                IPackageFragment[] iPackageFragmentArray = JavaCore.create((IProject)project).getPackageFragments();
                int n = iPackageFragmentArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IPackageFragment packageFragment = iPackageFragmentArray[n2];
                    if (!packageFragment.getElementName().equals("")) {
                        javaPackagesSet.add(packageFragment);
                    }
                    ++n2;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return javaPackagesSet;
    }

    private void createPackagesTreeViewer(Composite composite) {
        this.packagesTreeViewerList = new ArrayList<TreeViewer>();
        this.javaPackages = new ArrayList<SortedSet<IPackageFragment>>();
        for (IProject project : this.choosenProjects) {
            TreeViewer packagesTreeViewer = new TreeViewer(composite, 2048);
            Tree leftTree = packagesTreeViewer.getTree();
            leftTree.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
            PackagesTreeContentProvider packagesTreeContentProvider = new PackagesTreeContentProvider();
            packagesTreeViewer.setLabelProvider((IBaseLabelProvider)new PackageLabelProvider());
            packagesTreeViewer.setContentProvider((IContentProvider)packagesTreeContentProvider);
            this.javaPackages.add(this.getJavaPackages(project));
            packagesTreeContentProvider.setJavaPackages(this.javaPackages.get(this.javaPackages.size() - 1));
            this.packagesTreeViewerList.add(packagesTreeViewer);
        }
        this.removeDuplicates();
        this.setInput();
    }

    private void setInput() {
        int i = 0;
        while (i < this.packagesTreeViewerList.size()) {
            PackagesTreeContentProvider content = (PackagesTreeContentProvider)this.packagesTreeViewerList.get(i).getContentProvider();
            List<IPackageFragment> list = PackageUtil.getRootpackages(content, this.javaPackages.get(i));
            this.packagesTreeViewerList.get(i).setInput((Object)list.toArray(new IPackageFragment[list.size()]));
            this.packagesTreeViewerList.get(i).addFilter(this.selectedFilter);
            ++i;
        }
    }

    private void removeDuplicates() {
        int i = 0;
        while (i < this.javaPackages.size()) {
            TreeSet<IPackageFragment> temp = new TreeSet<IPackageFragment>(this.javaPackages.get(i));
            int j = 0;
            while (j < this.javaPackages.size()) {
                if (i != j) {
                    this.javaPackages.get(i).removeAll((Collection)this.javaPackages.get(j));
                    this.javaPackages.get(j).removeAll(temp);
                }
                ++j;
            }
            ++i;
        }
    }

    public void saveMergedPackages() {
        if (this.mergedPackages == null) {
            return;
        }
        String mapped = "";
        for (MergedPackage mPackage : this.mergedPackages) {
            mapped = String.valueOf(mapped) + mPackage.toString() + "\n";
        }
        this.projectConfiguration.getDifferOptions().put((Object)"JaMoPP.Java.Package.Normalization.Pattern", (Object)mapped.trim());
    }
}

