/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.ui.wizard.consolidation.listener;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.splevo.ui.wizard.consolidation.util.PackagesComparator;

public class PackagesCheckStateListener
implements ICheckStateListener {
    private SortedSet<IPackageFragment> javaPackages;

    public void setJavaPackages(SortedSet<IPackageFragment> javaPackages) {
        this.javaPackages = javaPackages;
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        CheckboxTreeViewer packagesTreeViewer = (CheckboxTreeViewer)event.getSource();
        packagesTreeViewer.setSubtreeChecked(event.getElement(), event.getChecked());
        for (IPackageFragment parentPackage : this.getParentPackages((IPackageFragment)event.getElement())) {
            int countOfCheckedSubpackages = this.getCountOfCheckedSubpackages(parentPackage, packagesTreeViewer);
            if (countOfCheckedSubpackages == this.getAllSubPackages(parentPackage).size()) {
                packagesTreeViewer.setGrayed((Object)parentPackage, false);
                packagesTreeViewer.setChecked((Object)parentPackage, true);
                continue;
            }
            if (countOfCheckedSubpackages > 0) {
                packagesTreeViewer.setChecked((Object)parentPackage, true);
                packagesTreeViewer.setGrayed((Object)parentPackage, true);
                continue;
            }
            packagesTreeViewer.setChecked((Object)parentPackage, false);
            packagesTreeViewer.setGrayed((Object)parentPackage, false);
        }
    }

    private List<IPackageFragment> getParentPackages(IPackageFragment childPackage) {
        ArrayList<IPackageFragment> parentPackages = new ArrayList<IPackageFragment>();
        String[] split = childPackage.getElementName().split("\\.");
        for (IPackageFragment javaPackage : this.javaPackages) {
            String parentName = "";
            int i = 0;
            while (i < split.length - 1) {
                parentName = i == 0 ? parentName.concat(split[i]) : parentName.concat("." + split[i]);
                if (javaPackage.getElementName().equals(parentName)) {
                    parentPackages.add(javaPackage);
                }
                ++i;
            }
        }
        Collections.sort(parentPackages, Collections.reverseOrder(new PackagesComparator()));
        return parentPackages;
    }

    private int getCountOfCheckedSubpackages(IPackageFragment parentPackage, CheckboxTreeViewer packagesTreeViewer) {
        int countOfCheckedSubpackages = 0;
        for (IPackageFragment javaPackage : this.javaPackages) {
            if (!javaPackage.getElementName().startsWith(parentPackage.getElementName()) || javaPackage.getElementName().equals(parentPackage.getElementName()) || !packagesTreeViewer.getChecked((Object)javaPackage)) continue;
            ++countOfCheckedSubpackages;
        }
        return countOfCheckedSubpackages;
    }

    public List<IPackageFragment> getAllSubPackages(IPackageFragment parentPackage) {
        ArrayList<IPackageFragment> subPackages = new ArrayList<IPackageFragment>();
        for (IPackageFragment javaPackage : this.javaPackages) {
            String parentPackageName = parentPackage.getElementName();
            if (!javaPackage.getElementName().startsWith(parentPackageName) || javaPackage.getElementName().equals(parentPackageName)) continue;
            subPackages.add(javaPackage);
        }
        return subPackages;
    }
}

