/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.ui.wizard.consolidation;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.splevo.project.SPLevoProject;
import org.splevo.ui.wizard.consolidation.provider.ProjectLabelProvider;

public class ProjectsSelectionWizardPage
extends WizardPage {
    private SPLevoProject projectConfiguration;
    private Text leadingVariantNameField;
    private Text integrationVariantNameField;
    private Table leadingProjectsTable;
    private Table integrationProjectsTable;

    public ProjectsSelectionWizardPage(SPLevoProject projectConfiguration) {
        super("Projects Selection Page");
        this.setTitle("Projects selection");
        this.setDescription("Define the projects to be consolidated.");
        this.setPageComplete(false);
        this.projectConfiguration = projectConfiguration;
    }

    public void createControl(Composite parent) {
        GridLayout layout = new GridLayout(4, false);
        layout.verticalSpacing = 15;
        layout.horizontalSpacing = 10;
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)layout);
        GridData gridDataSpanCells = new GridData(768);
        gridDataSpanCells.horizontalSpan = 2;
        gridDataSpanCells.grabExcessHorizontalSpace = true;
        this.createLabel(container, "Leading projects:", gridDataSpanCells);
        this.createLabel(container, "Integration projects:", gridDataSpanCells);
        this.createLabel(container, "Variant name:", null);
        this.leadingVariantNameField = this.createVariantNameField(container, new CheckPageCompletedListener(null, null));
        this.createLabel(container, "Variant name:", null);
        this.integrationVariantNameField = this.createVariantNameField(container, new CheckPageCompletedListener(null, null));
        this.leadingProjectsTable = this.createProjectsTable(container, new LeadingProjectsTableListener());
        this.integrationProjectsTable = this.createProjectsTable(container, new IntegrationProjectsTableListener());
        this.setControl((Control)container);
    }

    public IWizardPage getNextPage() {
        this.saveChosenProjects();
        return super.getNextPage();
    }

    private void saveChosenProjects() {
        this.projectConfiguration.setVariantNameLeading(this.leadingVariantNameField.getText().trim());
        this.projectConfiguration.setVariantNameIntegration(this.integrationVariantNameField.getText().trim());
        this.projectConfiguration.getLeadingProjects().clear();
        for (String chosenLeadingProjectName : this.getChosenProjectsNames(this.leadingProjectsTable)) {
            this.projectConfiguration.getLeadingProjects().add((Object)chosenLeadingProjectName);
        }
        this.projectConfiguration.getIntegrationProjects().clear();
        for (String chosenIntegrationProjectName : this.getChosenProjectsNames(this.integrationProjectsTable)) {
            this.projectConfiguration.getIntegrationProjects().add((Object)chosenIntegrationProjectName);
        }
    }

    private void createLabel(Composite container, String labelText, GridData layoutData) {
        Label label = new Label(container, 0);
        label.setText(labelText);
        if (layoutData != null) {
            label.setLayoutData((Object)layoutData);
        }
    }

    private Text createVariantNameField(Composite container, Listener listener) {
        Text variantNameField = new Text(container, 2048);
        variantNameField.setLayoutData((Object)new GridData(768));
        variantNameField.addListener(24, listener);
        return variantNameField;
    }

    private Table createProjectsTable(Composite container, Listener listener) {
        Composite innerContainer = new Composite(container, 0);
        innerContainer.setLayout((Layout)new GridLayout(1, false));
        GridData twoColumns = new GridData(4, 4, true, true);
        twoColumns.horizontalSpan = 2;
        innerContainer.setLayoutData((Object)twoColumns);
        Label label = new Label(innerContainer, 0);
        label.setText("Projects:");
        Table projectsTable = this.createProjectsTableViewer(innerContainer).getTable();
        projectsTable.setLayoutData((Object)new GridData(4, 4, true, true));
        projectsTable.addListener(13, listener);
        return projectsTable;
    }

    private TableViewer createProjectsTableViewer(Composite container) {
        TableViewer projectsTableViewer = new TableViewer(container, 2080);
        projectsTableViewer.setLabelProvider((IBaseLabelProvider)new ProjectLabelProvider());
        projectsTableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        projectsTableViewer.setInput((Object)this.getProjectsFromWorkspace());
        return projectsTableViewer;
    }

    private IProject[] getProjectsFromWorkspace() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        IProject[] projects = root.getProjects();
        return projects;
    }

    private boolean isProjectSelectionPageComplete() {
        boolean isLeadingProjectSelected = this.isAtLeastOneItemSelected(this.leadingProjectsTable);
        boolean isIntergrationProjectSelected = this.isAtLeastOneItemSelected(this.integrationProjectsTable);
        boolean isIntegrationVariantNameFilled = this.isFilled(this.integrationVariantNameField);
        boolean isLeadingVariantNameFilled = this.isFilled(this.leadingVariantNameField);
        return isLeadingVariantNameFilled && isIntegrationVariantNameFilled && isLeadingProjectSelected && isIntergrationProjectSelected;
    }

    private boolean isFilled(Text textField) {
        return textField.getText() != null && textField.getText().trim().length() > 0;
    }

    private boolean isAtLeastOneItemSelected(Table table) {
        boolean leadingProjectSelected = false;
        TableItem[] tableItemArray = table.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            if (item.getChecked()) {
                leadingProjectSelected = true;
                break;
            }
            ++n2;
        }
        return leadingProjectSelected;
    }

    private List<String> getChosenProjectsNames(Table projectsTable) {
        TableItem[] allProjects = projectsTable.getItems();
        ArrayList<String> chosenProjectsNames = new ArrayList<String>();
        TableItem[] tableItemArray = allProjects;
        int n = allProjects.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem project = tableItemArray[n2];
            if (project.getChecked()) {
                chosenProjectsNames.add(project.getText());
            }
            ++n2;
        }
        return chosenProjectsNames;
    }

    private class CheckPageCompletedListener
    implements Listener {
        private CheckPageCompletedListener() {
        }

        public void handleEvent(Event event) {
            ProjectsSelectionWizardPage.this.setPageComplete(ProjectsSelectionWizardPage.this.isProjectSelectionPageComplete());
        }

        /* synthetic */ CheckPageCompletedListener(CheckPageCompletedListener checkPageCompletedListener, CheckPageCompletedListener checkPageCompletedListener2) {
            this();
        }
    }

    private class IntegrationProjectsTableListener
    extends CheckPageCompletedListener {
        private IntegrationProjectsTableListener() {
        }

        @Override
        public void handleEvent(Event event) {
            if (!ProjectsSelectionWizardPage.this.isFilled(ProjectsSelectionWizardPage.this.integrationVariantNameField) && event.detail == 32) {
                List chosenIntegrationProjects = ProjectsSelectionWizardPage.this.getChosenProjectsNames(ProjectsSelectionWizardPage.this.integrationProjectsTable);
                int lastElementPosition = chosenIntegrationProjects.size() - 1;
                ProjectsSelectionWizardPage.this.integrationVariantNameField.setText((String)chosenIntegrationProjects.get(lastElementPosition));
            }
            super.handleEvent(event);
        }
    }

    private class LeadingProjectsTableListener
    extends CheckPageCompletedListener {
        private LeadingProjectsTableListener() {
        }

        @Override
        public void handleEvent(Event event) {
            if (!ProjectsSelectionWizardPage.this.isFilled(ProjectsSelectionWizardPage.this.leadingVariantNameField) && event.detail == 32) {
                List chosenLeadingProjects = ProjectsSelectionWizardPage.this.getChosenProjectsNames(ProjectsSelectionWizardPage.this.leadingProjectsTable);
                int lastElementPosition = chosenLeadingProjects.size() - 1;
                ProjectsSelectionWizardPage.this.leadingVariantNameField.setText((String)chosenLeadingProjects.get(lastElementPosition));
            }
            super.handleEvent(event);
        }
    }
}

