/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.ui.wizard.consolidation.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.viewers.IContentProvider;
import org.splevo.project.SPLevoProject;
import org.splevo.ui.wizard.consolidation.provider.PackagesTreeContentProvider;
import org.splevo.ui.wizard.consolidation.util.PackagesComparator;

public class PackageUtil {
    public static List<IProject> getAllChosenProjects(SPLevoProject projectConfiguration) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        ArrayList<IProject> allChosenProjects = new ArrayList<IProject>();
        for (String chosenProjectName : projectConfiguration.getLeadingProjects()) {
            allChosenProjects.add(root.getProject(chosenProjectName));
        }
        for (String chosenProjectName : projectConfiguration.getIntegrationProjects()) {
            allChosenProjects.add(root.getProject(chosenProjectName));
        }
        return allChosenProjects;
    }

    public static List<SortedSet<IPackageFragment>> getNonDuplicatesJavaPackages(SPLevoProject projectConfiguration) {
        ArrayList<SortedSet<IPackageFragment>> javaPackages = new ArrayList<SortedSet<IPackageFragment>>();
        for (IProject project : PackageUtil.getAllChosenProjects(projectConfiguration)) {
            javaPackages.add(PackageUtil.getJavaPackages(project));
        }
        PackageUtil.removeDuplicates(javaPackages);
        return javaPackages;
    }

    private static void removeDuplicates(List<SortedSet<IPackageFragment>> javaPackages) {
        int i = 0;
        while (i < javaPackages.size()) {
            TreeSet<IPackageFragment> temp = new TreeSet<IPackageFragment>(javaPackages.get(i));
            int j = 0;
            while (j < javaPackages.size()) {
                if (i != j) {
                    javaPackages.get(i).removeAll((Collection)javaPackages.get(j));
                    javaPackages.get(j).removeAll(temp);
                }
                ++j;
            }
            ++i;
        }
    }

    public static List<IPackageFragment> getRootpackages(IContentProvider contentProvider, SortedSet<IPackageFragment> javaPackages) {
        ArrayList<IPackageFragment> rootPackages = new ArrayList<IPackageFragment>();
        if (!(contentProvider instanceof PackagesTreeContentProvider)) {
            return rootPackages;
        }
        PackagesTreeContentProvider packagesTreeContentProvider = (PackagesTreeContentProvider)contentProvider;
        for (IPackageFragment javaPackage : javaPackages) {
            if (packagesTreeContentProvider.getParentPackage(javaPackage) != null) continue;
            rootPackages.add(javaPackage);
        }
        return rootPackages;
    }

    public static SortedSet<IPackageFragment> getJavaPackages(SPLevoProject projectConfiguration) {
        TreeSet<IPackageFragment> javaPackagesSet = new TreeSet<IPackageFragment>(new PackagesComparator());
        for (IProject project : PackageUtil.getAllChosenProjects(projectConfiguration)) {
            PackageUtil.addPackage(project, javaPackagesSet);
        }
        return javaPackagesSet;
    }

    private static SortedSet<IPackageFragment> getJavaPackages(IProject project) {
        TreeSet<IPackageFragment> javaPackagesSet = new TreeSet<IPackageFragment>(new PackagesComparator());
        PackageUtil.addPackage(project, javaPackagesSet);
        return javaPackagesSet;
    }

    private static void addPackage(IProject project, SortedSet<IPackageFragment> javaPackagesSet) {
        try {
            if (project.isNatureEnabled("org.eclipse.jdt.core.javanature")) {
                IPackageFragment[] iPackageFragmentArray = JavaCore.create((IProject)project).getPackageFragments();
                int n = iPackageFragmentArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IPackageFragment packageFragment = iPackageFragmentArray[n2];
                    if (!packageFragment.getElementName().equals("")) {
                        javaPackagesSet.add(packageFragment);
                    }
                    ++n2;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getName(IPackageFragment packageFragment) {
        return packageFragment != null ? packageFragment.getElementName() : "";
    }
}

