/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.ui.wizard.consolidation;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;
import org.splevo.project.ProjectFactory;
import org.splevo.project.SPLevoProject;
import org.splevo.project.utils.SPLevoProjectUtil;
import org.splevo.ui.nature.SPLevoNature;
import org.splevo.ui.wizard.consolidation.PackageMapWizardPage;
import org.splevo.ui.wizard.consolidation.PackageScopeDefinitionWizardPage;
import org.splevo.ui.wizard.consolidation.ProjectsSelectionWizardPage;

public class NewConsolidationProjectWizard
extends Wizard
implements INewWizard,
IExecutableExtension {
    public static final String WIZARD_NAME = "New Consolidation Project Wizard";
    private static Logger logger = Logger.getLogger(NewConsolidationProjectWizard.class);
    private WizardNewProjectCreationPage projectCreationPage;
    private IConfigurationElement configurationElement;
    private SPLevoProject projectConfiguration;
    private PackageScopeDefinitionWizardPage packageScopeDefinitionWizardPage;
    private PackageMapWizardPage packageMapWizardPage;

    public NewConsolidationProjectWizard() {
        this.setWindowTitle(WIZARD_NAME);
    }

    public void addPages() {
        super.addPages();
        this.projectCreationPage = new WizardNewProjectCreationPage("Consolidation Project Wizard");
        this.projectCreationPage.setTitle("Consolidation Project");
        this.projectCreationPage.setDescription("Create a new project for consolidating project copies into a variable product line.");
        this.projectConfiguration = ProjectFactory.eINSTANCE.createSPLevoProject();
        this.packageScopeDefinitionWizardPage = new PackageScopeDefinitionWizardPage(this.projectConfiguration);
        this.packageMapWizardPage = new PackageMapWizardPage(this.projectConfiguration);
        this.addPage((IWizardPage)this.projectCreationPage);
        this.addPage((IWizardPage)new ProjectsSelectionWizardPage(this.projectConfiguration));
        this.addPage((IWizardPage)this.packageScopeDefinitionWizardPage);
        this.addPage((IWizardPage)this.packageMapWizardPage);
    }

    public boolean performFinish() {
        String name = this.projectCreationPage.getProjectName();
        URI nonDefaultLocation = null;
        if (!this.projectCreationPage.useDefaults()) {
            nonDefaultLocation = this.projectCreationPage.getLocationURI();
        }
        try {
            IProject project = this.createBaseProject(name, nonDefaultLocation);
            String splevoProjectFileName = String.valueOf(project.getName()) + "." + "splevoproject";
            File filePath = new File(String.valueOf(project.getFullPath().toString()) + File.separator + splevoProjectFileName);
            this.projectConfiguration.setWorkspace(String.valueOf(project.getName()) + "/");
            this.projectConfiguration.setName(project.getName());
            this.packageScopeDefinitionWizardPage.saveChosenPackages();
            this.packageMapWizardPage.saveMergedPackages();
            try {
                SPLevoProjectUtil.save((SPLevoProject)this.projectConfiguration, (File)filePath);
                project.refreshLocal(-1, (IProgressMonitor)new NullProgressMonitor());
                IFile file = project.getFile(splevoProjectFileName);
                FileEditorInput inputFile = new FileEditorInput(file);
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                page.openEditor((IEditorInput)inputFile, "org.splevo.ui.editors.SPLevoProjectEditor");
            }
            catch (IOException e) {
                logger.error((Object)"Failed to save SPLevo project configuration file", (Throwable)e);
            }
            this.addNature(project);
        }
        catch (CoreException e) {
            logger.error((Object)"Failed to create consolidation project", (Throwable)e);
        }
        BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.configurationElement);
        return this.projectCreationPage.isPageComplete();
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.configurationElement = config;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    private IProject createBaseProject(String projectName, URI nonDefaultLocation) {
        IProject newProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (!newProject.exists()) {
            URI projectLocation = nonDefaultLocation;
            IProjectDescription desc = newProject.getWorkspace().newProjectDescription(newProject.getName());
            if (nonDefaultLocation != null && ResourcesPlugin.getWorkspace().getRoot().getLocationURI().equals(nonDefaultLocation)) {
                projectLocation = null;
            }
            desc.setLocationURI(projectLocation);
            try {
                newProject.create(desc, null);
            }
            catch (CoreException e) {
                logger.error((Object)"Exception thrown: ", (Throwable)e);
            }
            if (!newProject.isOpen()) {
                try {
                    newProject.open(null);
                }
                catch (CoreException e) {
                    logger.error((Object)"Exception thrown: ", (Throwable)e);
                }
            }
        }
        return newProject;
    }

    private void addNature(IProject project) throws CoreException {
        if (!project.hasNature(SPLevoNature.getNatureId())) {
            IProjectDescription description = project.getDescription();
            String[] prevNatures = description.getNatureIds();
            String[] newNatures = new String[prevNatures.length + 1];
            System.arraycopy(prevNatures, 0, newNatures, 0, prevNatures.length);
            newNatures[prevNatures.length] = SPLevoNature.getNatureId();
            description.setNatureIds(newNatures);
            IProgressMonitor monitor = null;
            project.setDescription(description, monitor);
        }
    }
}

