/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.ui.dashboard;

import com.google.common.collect.Iterables;
import java.io.File;
import java.util.ArrayList;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.wb.swt.ResourceManager;
import org.eclipse.wb.swt.SWTResourceManager;
import org.splevo.project.SPLevoProject;
import org.splevo.project.VPMModelReference;
import org.splevo.ui.commons.util.WorkspaceUtil;
import org.splevo.ui.dashboard.AbstractDashboardTab;
import org.splevo.ui.editors.SPLevoProjectEditor;
import org.splevo.ui.listeners.GenerateFeatureModelListener;
import org.splevo.ui.listeners.InitVPMListener;
import org.splevo.ui.listeners.OpenVPMListener;
import org.splevo.ui.listeners.StartRefactoringListener;
import org.splevo.ui.listeners.VPMAnalysisListener;

public class ProcessControlTab
extends AbstractDashboardTab {
    private Button initVpmBtn;
    private Button analyzeVPMBtn;
    private Button startRefactoringBtn;
    private Button generateFMBtn;
    private Button openVPMBtn;

    public ProcessControlTab(SPLevoProjectEditor splevoProjectEditor, TabFolder tabFolder, int tabIndex) {
        super(splevoProjectEditor);
        this.createTab(tabFolder, tabIndex);
    }

    private void createTab(TabFolder tabFolder, int tabIndex) {
        TabItem tbtmProcessControl = new TabItem(tabFolder, 0, tabIndex);
        tbtmProcessControl.setText("Process Control");
        Composite mainContainer = new Composite((Composite)tabFolder, 0);
        tbtmProcessControl.setControl((Control)mainContainer);
        GridLayout layout = new GridLayout(9, false);
        layout.horizontalSpacing = 5;
        layout.verticalSpacing = 1;
        mainContainer.setLayout((Layout)layout);
        Label lblSplevoDashboard = new Label(mainContainer, 0);
        GridData d = new GridData(0x1000000, 0x1000000, false, false, 9, 1);
        d.heightHint = lblSplevoDashboard.computeSize((int)-1, (int)-1).y * 2;
        lblSplevoDashboard.setLayoutData((Object)d);
        lblSplevoDashboard.setFont(SWTResourceManager.getFont("Arial", 14, 1));
        lblSplevoDashboard.setText("SPLevo Dashboard");
        Composite filler1 = new Composite(mainContainer, 0);
        GridData layoutData = new GridData(0x1000000, 0x1000000, false, false, 4, 1);
        layoutData.heightHint = 0;
        filler1.setLayoutData((Object)layoutData);
        Image circleImage = ResourceManager.getPluginImage("org.splevo.ui", "icons/arrow_circle.png");
        Label circleLbl = new Label(mainContainer, 0);
        circleLbl.setImage(circleImage);
        circleLbl.setLayoutData((Object)new GridData(0x1000000, 1024, false, false));
        Composite filler2 = new Composite(mainContainer, 0);
        filler2.setLayoutData((Object)layoutData);
        Label activityStart = new Label(mainContainer, 0);
        activityStart.setImage(ResourceManager.getPluginImage("org.splevo.ui", "icons/bullet_green.png"));
        this.addActivityFlowButton(mainContainer);
        this.initVpmBtn = new Button(mainContainer, 64);
        this.initVpmBtn.addMouseListener((MouseListener)new InitVPMListener(this.getSplevoProjectEditor()));
        this.initVpmBtn.setText("Init\nVPM");
        this.getGridDataForButtons(this.initVpmBtn);
        this.addActivityFlowButton(mainContainer);
        this.analyzeVPMBtn = new Button(mainContainer, 64);
        this.analyzeVPMBtn.addMouseListener((MouseListener)new VPMAnalysisListener(this.getSplevoProjectEditor()));
        this.analyzeVPMBtn.setText("Refine\nVPM");
        this.getGridDataForButtons(this.analyzeVPMBtn);
        this.addActivityFlowButton(mainContainer);
        this.startRefactoringBtn = new Button(mainContainer, 64);
        this.startRefactoringBtn.addMouseListener((MouseListener)new StartRefactoringListener(this.getSplevoProjectEditor()));
        this.startRefactoringBtn.setText("Refactor\nCopies");
        this.getGridDataForButtons(this.startRefactoringBtn);
        this.addActivityFlowButton(mainContainer);
        this.generateFMBtn = new Button(mainContainer, 64);
        this.generateFMBtn.addMouseListener((MouseListener)new GenerateFeatureModelListener(this.getSplevoProjectEditor()));
        this.generateFMBtn.setText("Export\nSPL");
        this.getGridDataForButtons(this.generateFMBtn);
        Composite filler3 = new Composite(mainContainer, 0);
        filler3.setLayoutData((Object)layoutData);
        this.openVPMBtn = new Button(mainContainer, 0);
        this.openVPMBtn.setImage(ResourceManager.getPluginImage("org.splevo.ui", "icons/splevo.gif"));
        this.openVPMBtn.addMouseListener((MouseListener)new OpenVPMListener(this.getSplevoProjectEditor()));
        this.openVPMBtn.setLayoutData((Object)new GridData(0x1000000, 128, false, true));
        this.openVPMBtn.setAlignment(0x1000000);
    }

    private void getGridDataForButtons(Button button) {
        GridData gridData = new GridData();
        gridData.widthHint = button.computeSize((int)-1, (int)-1).x;
        button.setLayoutData((Object)gridData);
    }

    private void addActivityFlowButton(Composite container) {
        Label iconLabel = new Label(container, 0);
        iconLabel.setImage(ResourceManager.getPluginImage("org.splevo.ui", "icons/arrow_right.png"));
        iconLabel.setAlignment(0x1000000);
    }

    public void enableButtonsIfInformationAvailable() {
        this.disableAllButtonsExceptProjectSelection();
        if (!this.projectsSelected()) {
            return;
        }
        this.initVpmBtn.setEnabled(true);
        if (!this.vpmAvailable()) {
            return;
        }
        this.openVPMBtn.setEnabled(true);
        this.analyzeVPMBtn.setEnabled(true);
        this.startRefactoringBtn.setEnabled(true);
        this.generateFMBtn.setEnabled(true);
    }

    private boolean vpmAvailable() {
        SPLevoProject splevoProject = this.getSPLevoProject();
        if (splevoProject.getVpmModelReferences().size() > 0) {
            String vpmPath = WorkspaceUtil.getAbsoluteFromWorkspaceRelativePath((String)((VPMModelReference)Iterables.getLast((Iterable)splevoProject.getVpmModelReferences())).getPath());
            return new File(vpmPath).canRead();
        }
        return false;
    }

    private boolean projectsSelected() {
        SPLevoProject splevoProject = this.getSPLevoProject();
        return splevoProject.getLeadingProjects().size() > 0 && splevoProject.getIntegrationProjects().size() > 0;
    }

    private void disableAllButtonsExceptProjectSelection() {
        ArrayList<Button> buttons = new ArrayList<Button>();
        buttons.add(this.generateFMBtn);
        buttons.add(this.initVpmBtn);
        buttons.add(this.analyzeVPMBtn);
        buttons.add(this.startRefactoringBtn);
        buttons.add(this.openVPMBtn);
        for (Control control : buttons) {
            control.setEnabled(false);
        }
    }
}

