/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.ui.dashboard;

import java.util.List;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.PojoProperties;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.wb.swt.ResourceManager;
import org.splevo.project.SPLevoProject;
import org.splevo.ui.dashboard.AbstractDashboardTab;
import org.splevo.ui.editors.SPLevoProjectEditor;
import org.splevo.ui.editors.listener.MarkDirtyListener;
import org.splevo.ui.editors.listener.ProjectDropListener;

public class ProjectSelectionTab
extends AbstractDashboardTab {
    private Transfer[] transferTypes = new Transfer[]{FileTransfer.getInstance(), LocalSelectionTransfer.getTransfer()};
    private int dragNDropOperations = 2;
    private Text inputVariantNameLeading;
    private Text inputVariantNameIntegration;

    public ProjectSelectionTab(SPLevoProjectEditor splevoProjectEditor, TabFolder tabFolder, int tabIndex) {
        super(splevoProjectEditor);
        this.createTab(tabFolder, tabIndex);
    }

    private void createTab(TabFolder tabFolder, int tabIndex) {
        final SPLevoProject splevoProject = this.getSPLevoProject();
        TabItem tbtmProjectSelection = new TabItem(tabFolder, 0, tabIndex);
        tbtmProjectSelection.setText("Source Projects");
        Composite composite = new Composite((Composite)tabFolder, 0);
        tbtmProjectSelection.setControl((Control)composite);
        composite.setLayout(null);
        Label lblNewLabel = new Label(composite, 0);
        lblNewLabel.setToolTipText("Select the source entity models of the leading projects");
        lblNewLabel.setBounds(10, 10, 740, 20);
        lblNewLabel.setText("Define the projects to be consolidated");
        Label labelVariantNameLeading = new Label(composite, 0);
        labelVariantNameLeading.setBounds(10, 37, 106, 20);
        labelVariantNameLeading.setText("Variant Name:");
        Label labelVariantNameIntegration = new Label(composite, 0);
        labelVariantNameIntegration.setText("Variant Name:");
        labelVariantNameIntegration.setBounds(430, 36, 106, 20);
        this.inputVariantNameLeading = new Text(composite, 2048);
        this.inputVariantNameLeading.setBounds(122, 36, 238, 26);
        this.inputVariantNameIntegration = new Text(composite, 2048);
        this.inputVariantNameIntegration.setBounds(542, 36, 238, 26);
        final TableViewer viewerLeadingProjects = new TableViewer(composite, 67584);
        viewerLeadingProjects.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        viewerLeadingProjects.setInput((Object)splevoProject.getLeadingProjects());
        ProjectDropListener dropListenerLeadingProjects = new ProjectDropListener(this.getSplevoProjectEditor(), (Viewer)viewerLeadingProjects, (List<String>)splevoProject.getLeadingProjects(), this.inputVariantNameLeading);
        viewerLeadingProjects.addDropSupport(this.dragNDropOperations, this.transferTypes, (DropTargetListener)dropListenerLeadingProjects);
        Table tableLeadingProjects = viewerLeadingProjects.getTable();
        tableLeadingProjects.setHeaderVisible(true);
        tableLeadingProjects.setLinesVisible(true);
        tableLeadingProjects.setBounds(10, 63, 350, 209);
        TableColumn tblclmnLeadingProjects = new TableColumn(tableLeadingProjects, 0);
        tblclmnLeadingProjects.setWidth(tblclmnLeadingProjects.getParent().getBounds().width);
        tblclmnLeadingProjects.setText("Leading Projects");
        final TableViewer viewerIntegrationProjects = new TableViewer(composite, 67584);
        viewerIntegrationProjects.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        viewerIntegrationProjects.setInput((Object)splevoProject.getIntegrationProjects());
        ProjectDropListener dropListenerIntegrationProjects = new ProjectDropListener(this.getSplevoProjectEditor(), (Viewer)viewerIntegrationProjects, (List<String>)splevoProject.getIntegrationProjects(), this.inputVariantNameIntegration);
        viewerIntegrationProjects.addDropSupport(this.dragNDropOperations, this.transferTypes, (DropTargetListener)dropListenerIntegrationProjects);
        Table tableIntegrationProjects = viewerIntegrationProjects.getTable();
        tableIntegrationProjects.setHeaderVisible(true);
        tableIntegrationProjects.setLinesVisible(true);
        tableIntegrationProjects.setBounds(430, 63, 350, 209);
        TableColumn tblclmnIntegrationProjects = new TableColumn(tableIntegrationProjects, 0);
        tblclmnIntegrationProjects.setWidth(tblclmnIntegrationProjects.getParent().getBounds().width);
        tblclmnIntegrationProjects.setText("Integration Projects");
        Button btnClear = new Button(composite, 0);
        btnClear.setGrayed(true);
        btnClear.setImage(ResourceManager.getPluginImage("org.splevo.ui", "icons/cross.png"));
        btnClear.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                splevoProject.getLeadingProjects().clear();
                viewerLeadingProjects.refresh();
                ProjectSelectionTab.this.getSplevoProjectEditor().markAsDirty();
            }
        });
        btnClear.setBounds(366, 63, 30, 30);
        Button btnClearList = new Button(composite, 0);
        btnClearList.setToolTipText("Clear the list of source projects to integrate.");
        btnClearList.setImage(ResourceManager.getPluginImage("org.splevo.ui", "icons/cross.png"));
        btnClearList.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                splevoProject.getIntegrationProjects().clear();
                viewerIntegrationProjects.refresh();
                ProjectSelectionTab.this.getSplevoProjectEditor().markAsDirty();
            }
        });
        btnClearList.setBounds(786, 63, 30, 30);
        composite.setTabList(new Control[]{tableLeadingProjects, tableIntegrationProjects});
    }

    public DataBindingContext initDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        SPLevoProject splevoProject = this.getSPLevoProject();
        MarkDirtyListener markDirtyListener = new MarkDirtyListener(this.getSplevoProjectEditor());
        ISWTObservableValue observeTextInputVariantNameLeadingObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.inputVariantNameLeading);
        IObservableValue variantNameLeadingGetSplevoProjectObserveValue = PojoProperties.value((String)"variantNameLeading").observe((Object)splevoProject);
        variantNameLeadingGetSplevoProjectObserveValue.addChangeListener((IChangeListener)markDirtyListener);
        bindingContext.bindValue((IObservableValue)observeTextInputVariantNameLeadingObserveWidget, variantNameLeadingGetSplevoProjectObserveValue, null, null);
        ISWTObservableValue observeTextInputVariantNameIntegrationObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.inputVariantNameIntegration);
        IObservableValue variantNameIntegrationGetSplevoProjectObserveValue = PojoProperties.value((String)"variantNameIntegration").observe((Object)splevoProject);
        variantNameIntegrationGetSplevoProjectObserveValue.addChangeListener((IChangeListener)markDirtyListener);
        bindingContext.bindValue((IObservableValue)observeTextInputVariantNameIntegrationObserveWidget, variantNameIntegrationGetSplevoProjectObserveValue, null, null);
        return bindingContext;
    }
}

