/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.ui.editors.listener;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.splevo.ui.editors.SPLevoProjectEditor;

public class ProjectDropListener
extends ViewerDropAdapter {
    private Logger logger = Logger.getLogger(ProjectDropListener.class);
    private List<String> projectListContainer;
    private Text inputVariantName;
    private SPLevoProjectEditor spLevoProjectEditor;

    public ProjectDropListener(SPLevoProjectEditor spLevoProjectEditor, Viewer viewer, List<String> projectListContainer, Text inputVariantName) {
        super(viewer);
        this.spLevoProjectEditor = spLevoProjectEditor;
        this.projectListContainer = projectListContainer;
        this.inputVariantName = inputVariantName;
    }

    public boolean performDrop(Object selection) {
        List<IJavaProject> javaProjects = this.getJavaProjectsFromSelection(selection);
        if (javaProjects.size() > 0) {
            this.addProjectsToTheListContainer(javaProjects);
            this.getViewer().setInput(this.projectListContainer);
            this.spLevoProjectEditor.updateUI();
            return true;
        }
        Shell shell = this.spLevoProjectEditor.getEditorSite().getShell();
        MessageDialog.openWarning((Shell)shell, (String)"Cannot be added to list.", (String)"Only Java Projects can be added to the list.");
        return false;
    }

    private void addProjectsToTheListContainer(List<IJavaProject> javaProjects) {
        for (IJavaProject javaProject : javaProjects) {
            this.addProjectToListAndSetVariantName(javaProject.getElementName());
        }
    }

    private List<IJavaProject> getJavaProjectsFromSelection(Object selectionObject) {
        ArrayList<IJavaProject> javaProjects = new ArrayList<IJavaProject>();
        if (selectionObject instanceof TreeSelection) {
            this.addJavaProjectsFromSelectionToList(javaProjects, (TreeSelection)selectionObject);
        }
        return javaProjects;
    }

    private void addJavaProjectsFromSelectionToList(List<IJavaProject> javaProjects, TreeSelection selection) {
        for (Object selectedElement : selection.toList()) {
            IJavaProject project;
            if (selectedElement instanceof IJavaProject) {
                project = (IJavaProject)selectedElement;
                javaProjects.add(project);
            }
            if (!(selectedElement instanceof IProject)) continue;
            project = (IProject)selectedElement;
            try {
                IProjectNature nature = project.getNature("org.eclipse.jdt.core.javanature");
                if (!this.isNatureNotNullAndInstanceOfIJavaProject(nature)) continue;
                javaProjects.add((IJavaProject)nature);
            }
            catch (CoreException e) {
                this.logger.warn((Object)"Project could not be converted into a JavaProject so drop failed.");
            }
        }
    }

    private boolean isNatureNotNullAndInstanceOfIJavaProject(IProjectNature nature) {
        return nature != null && nature instanceof IJavaProject;
    }

    private void addProjectToListAndSetVariantName(String name) {
        if (!this.projectListContainer.contains(name)) {
            this.projectListContainer.add(name);
        }
        if (this.inputVariantName.getText() == null || this.inputVariantName.getText().equals("")) {
            this.inputVariantName.setText(name);
        }
    }

    public boolean validateDrop(Object target, int operation, TransferData transferType) {
        return true;
    }
}

