/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.ui.handler;

import java.io.File;
import org.apache.log4j.Logger;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.ide.IDE;
import org.splevo.project.SPLevoProject;
import org.splevo.ui.commons.util.WorkspaceUtil;
import org.splevo.ui.editors.SPLevoProjectEditor;

public class OpenDiffModelHandler
extends AbstractHandler {
    private Logger logger = Logger.getLogger(OpenDiffModelHandler.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IEditorPart activeEditor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        if (!(activeEditor instanceof SPLevoProjectEditor)) {
            return null;
        }
        SPLevoProjectEditor splevoProjectEditor = (SPLevoProjectEditor)activeEditor;
        SPLevoProject project = splevoProjectEditor.getSplevoProject();
        String diffingModelPath = project.getDiffingModelPath();
        if (diffingModelPath != null && diffingModelPath.length() > 0) {
            String basePath = WorkspaceUtil.getAbsoluteWorkspacePath();
            File fileToOpen = new File(String.valueOf(basePath) + File.separator + diffingModelPath);
            IFileStore fileStore = EFS.getLocalFileSystem().getStore(fileToOpen.toURI());
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            try {
                IDE.openEditorOnFileStore((IWorkbenchPage)page, (IFileStore)fileStore);
            }
            catch (PartInitException pie) {
                this.logger.error((Object)"failed to open diff file.");
            }
        }
        return null;
    }
}

