/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.ui.jobs;

import de.uka.ipd.sdq.workflow.jobs.AbstractBlackboardInteractingJob;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.splevo.ui.jobs.SPLevoBlackBoard;
import org.splevo.vpm.analyzer.DefaultVPMAnalyzerService;
import org.splevo.vpm.analyzer.VPMAnalyzerService;
import org.splevo.vpm.analyzer.refinement.DetectionRule;
import org.splevo.vpm.refinement.RefinementFactory;
import org.splevo.vpm.refinement.RefinementModel;

public class DetectRefinementsJob
extends AbstractBlackboardInteractingJob<SPLevoBlackBoard> {
    private VPMAnalyzerService vpmAnalyzerService = new DefaultVPMAnalyzerService();
    private List<DetectionRule> detectionRules;
    private boolean useMergeDetection;
    private boolean fullRefinementReasons;

    public DetectRefinementsJob(List<DetectionRule> detectionRules, boolean useMergeDetection, boolean fullRefinementReasons) {
        this.detectionRules = detectionRules;
        this.useMergeDetection = useMergeDetection;
        this.fullRefinementReasons = fullRefinementReasons;
    }

    public void execute(IProgressMonitor monitor) {
        List refinements = this.vpmAnalyzerService.deriveRefinements(((SPLevoBlackBoard)this.getBlackboard()).getVpmGraph(), this.detectionRules, this.useMergeDetection, this.fullRefinementReasons);
        if (monitor.isCanceled()) {
            monitor.done();
            this.logger.info((Object)"Workflow cancled.");
            return;
        }
        this.logger.info((Object)("Store Refinement model in blackboard (" + refinements.size() + " Refinements)"));
        RefinementModel refinementModel = RefinementFactory.eINSTANCE.createRefinementModel();
        refinementModel.getRefinements().addAll((Collection)refinements);
        ((SPLevoBlackBoard)this.getBlackboard()).setRefinementModel(refinementModel);
        monitor.done();
    }

    public String getName() {
        return "Detect Refinements Job";
    }

    public void cleanup(IProgressMonitor arg0) {
    }
}

