/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.ui.jobs;

import de.uka.ipd.sdq.workflow.jobs.AbstractBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.jobs.JobFailedException;
import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.splevo.project.SPLevoProject;
import org.splevo.project.VPMModelReference;
import org.splevo.ui.commons.util.JobUtil;
import org.splevo.ui.jobs.SPLevoBlackBoard;
import org.splevo.vpm.VPMUtil;
import org.splevo.vpm.software.SoftwarePackage;
import org.splevo.vpm.variability.VariationPointModel;
import org.splevo.vpm.variability.variabilityPackage;

public class LoadVPMJob
extends AbstractBlackboardInteractingJob<SPLevoBlackBoard> {
    private SPLevoProject splevoProject;
    private final int targetVPMIndex;

    public LoadVPMJob(SPLevoProject splevoProject) {
        this(splevoProject, -1);
    }

    public LoadVPMJob(SPLevoProject splevoProject, int targetVPMIndex) {
        this.splevoProject = splevoProject;
        this.targetVPMIndex = targetVPMIndex;
    }

    public void execute(IProgressMonitor monitor) throws JobFailedException {
        VariationPointModel vpm;
        this.logger.info((Object)"Load vpm model");
        variabilityPackage.eINSTANCE.eClass();
        SoftwarePackage.eINSTANCE.eClass();
        int index = this.targetVPMIndex;
        if (this.targetVPMIndex == -1) {
            index = this.splevoProject.getVpmModelReferences().size() - 1;
        }
        VPMModelReference vpmReference = (VPMModelReference)this.splevoProject.getVpmModelReferences().get(index);
        ResourceSet resourceSet = JobUtil.initResourceSet((SPLevoProject)this.splevoProject, (boolean)vpmReference.isRefactoringStarted());
        try {
            File vpmFile = new File(vpmReference.getPath());
            vpm = VPMUtil.loadVariationPointModel((File)vpmFile, (ResourceSet)resourceSet);
        }
        catch (Exception e) {
            throw new JobFailedException("Failed to load vpm model.", (Throwable)e);
        }
        EcoreUtil.resolveAll((EObject)vpm);
        this.logger.info((Object)"Put variation point model on the blackboard");
        ((SPLevoBlackBoard)this.getBlackboard()).setVariationPointModel(vpm);
        monitor.done();
    }

    public String getName() {
        return "Load VPM model Job";
    }

    public void cleanup(IProgressMonitor arg0) {
    }
}

