/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.ui.jobs;

import de.uka.ipd.sdq.workflow.jobs.AbstractBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.jobs.JobFailedException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.splevo.project.SPLevoProject;
import org.splevo.project.VPMModelReference;
import org.splevo.ui.jobs.SPLevoBlackBoard;
import org.splevo.ui.vpexplorer.util.VPMUIUtil;
import org.splevo.vpm.variability.VariationPointModel;

public class OpenVPMJob
extends AbstractBlackboardInteractingJob<SPLevoBlackBoard> {
    protected final SPLevoProject splevoProject;
    protected VPMModelReference vpmReference = null;

    public OpenVPMJob(SPLevoProject splevoProject, VPMModelReference vpmReference) {
        this.splevoProject = splevoProject;
        this.vpmReference = vpmReference;
    }

    public void execute(IProgressMonitor monitor) throws JobFailedException {
        if (this.splevoProject != null && this.vpmReference != null) {
            this.logger.info((Object)"Trigger Job to Open VPM from file");
            VPMUIUtil.openVPExplorer((SPLevoProject)this.splevoProject, (VPMModelReference)this.vpmReference);
        } else {
            this.logger.info((Object)"Trigger Job to Open VPm from Blackboard");
            VariationPointModel vpm = ((SPLevoBlackBoard)this.getBlackboard()).getVariationPointModel();
            VPMUIUtil.openVPExplorer((SPLevoProject)this.splevoProject, (VariationPointModel)vpm);
        }
        monitor.done();
    }

    public String getName() {
        return "Open VPM in VP Explorer";
    }

    public void cleanup(IProgressMonitor arg0) {
    }
}

