/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.ui.jobs;

import au.com.bytecode.opencsv.CSVWriter;
import com.google.common.io.Files;
import de.uka.ipd.sdq.workflow.jobs.AbstractBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.jobs.JobFailedException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.splevo.project.SPLevoProject;
import org.splevo.ui.commons.util.WorkspaceUtil;
import org.splevo.ui.jobs.SPLevoBlackBoard;
import org.splevo.vpm.refinement.Refinement;
import org.splevo.vpm.refinement.RefinementModel;
import org.splevo.vpm.refinement.RefinementUtil;
import org.splevo.vpm.variability.Variant;
import org.splevo.vpm.variability.VariationPoint;

public class SaveRefinementModelJob
extends AbstractBlackboardInteractingJob<SPLevoBlackBoard> {
    private String targetFile = null;
    private SPLevoProject splevoProject = null;
    private FORMAT format = FORMAT.ECORE_XMI;

    protected SaveRefinementModelJob(SPLevoProject splevoProject, String targetFile) {
        this.splevoProject = splevoProject;
        this.targetFile = targetFile;
    }

    protected SaveRefinementModelJob(SPLevoProject splevoProject, String targetFile, FORMAT format) {
        this(splevoProject, targetFile);
        this.format = format;
    }

    public SaveRefinementModelJob(SPLevoProject splevoProject, FORMAT format) {
        this(splevoProject, null, format);
    }

    public void execute(IProgressMonitor monitor) throws JobFailedException {
        RefinementModel refModel = ((SPLevoBlackBoard)this.getBlackboard()).getRefinementModel();
        String absoluteSavePathWithoutExtension = this.constructAbsoluteFilenameWithoutExtension();
        try {
            Files.createParentDirs((File)new File(absoluteSavePathWithoutExtension));
        }
        catch (IOException e) {
            throw new JobFailedException("Creation of destination folder failed.", (Throwable)e);
        }
        switch (this.format) {
            case CSV: {
                SaveRefinementModelJob.exportResultCSV(refModel, absoluteSavePathWithoutExtension);
                break;
            }
            case ECORE_XMI: {
                SaveRefinementModelJob.exportEcoreXMI(refModel, absoluteSavePathWithoutExtension, this.logger);
                break;
            }
        }
        monitor.done();
    }

    private String constructAbsoluteFilenameWithoutExtension() {
        String workspaceRelativeResultDirectory = String.valueOf(this.splevoProject.getWorkspace()) + "models/analyses-results/";
        String filenameBase = this.targetFile;
        if (filenameBase == null) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd-HHmmss");
            Calendar cal = Calendar.getInstance();
            filenameBase = dateFormat.format(cal.getTime());
        }
        String relativeBaseFilename = String.valueOf(workspaceRelativeResultDirectory) + filenameBase;
        return WorkspaceUtil.getAbsoluteFromWorkspaceRelativePath((String)relativeBaseFilename);
    }

    private static void exportResultCSV(RefinementModel refModel, String targetPath) throws JobFailedException {
        String resultFilePath = String.valueOf(targetPath) + "-results.csv";
        CSVWriter writer = null;
        try {
            try {
                writer = new CSVWriter((Writer)new FileWriter(resultFilePath));
                String[] header = new String[]{"Type", "VP ASTNode", "Leading AST Node", "Integration AST Node"};
                writer.writeNext(header);
                for (Refinement refinement : refModel.getRefinements()) {
                    String type = refinement.getType().toString();
                    for (VariationPoint vp : refinement.getVariationPoints()) {
                        StringBuilder leadingVariant = new StringBuilder("");
                        StringBuilder integrationVariant = new StringBuilder("");
                        for (Variant v : vp.getVariants()) {
                            if (v.getLeading().booleanValue()) {
                                leadingVariant.append(v.getImplementingElements().toString());
                                continue;
                            }
                            integrationVariant.append(v.getImplementingElements().toString());
                        }
                        String vpLocation = vp.getLocation().toString();
                        String[] result = new String[]{type, vpLocation, "" + leadingVariant, "" + integrationVariant};
                        writer.writeNext(result);
                    }
                }
            }
            catch (Exception e) {
                throw new JobFailedException("Failed to write csv export", (Throwable)e);
            }
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    throw new JobFailedException("Failed to save csv file", (Throwable)e);
                }
            }
        }
    }

    private static void exportEcoreXMI(RefinementModel refModel, String targetPath, Logger logger) throws JobFailedException {
        logger.info((Object)"Save Refinement Model");
        try {
            String modelPath = String.valueOf(targetPath) + ".refinement";
            RefinementUtil.save((RefinementModel)refModel, (File)new File(modelPath), (boolean)true);
        }
        catch (IOException e) {
            throw new JobFailedException("Failed to save refinement model as xmi.", (Throwable)e);
        }
    }

    public String getName() {
        return "Save Refinement Model Job";
    }

    public void cleanup(IProgressMonitor arg0) {
    }

    public static enum FORMAT {
        ECORE_XMI,
        CSV,
        NONE;

    }
}

