/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.ui.refinementbrowser.action;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.splevo.ui.SPLevoUIPlugin;
import org.splevo.ui.listeners.WorkflowListenerUtil;
import org.splevo.ui.refinementbrowser.VPMRefinementBrowser;
import org.splevo.ui.workflow.VPMRefinementWorkflowConfiguration;
import org.splevo.ui.workflow.VPMRefinementWorkflowDelegate;
import org.splevo.vpm.refinement.Refinement;
import org.splevo.vpm.variability.VariationPoint;
import org.splevo.vpm.variability.VariationPointGroup;
import org.splevo.vpm.variability.VariationPointModel;

public class ApplyRefinementsAction
extends Action {
    protected final VPMRefinementBrowser vpmRefinementBrowser;

    public ApplyRefinementsAction(VPMRefinementBrowser vpmRefinementBrowser, String text) {
        super(text);
        this.vpmRefinementBrowser = vpmRefinementBrowser;
    }

    public void runWithEvent(Event event) {
        List<Refinement> refinements = this.getRefinementsFromRefinementBrowser();
        if (refinements.size() == 0) {
            Shell shell = event.widget.getDisplay().getActiveShell();
            boolean cancel = MessageDialog.openQuestion((Shell)shell, (String)"SPLevo Info", (String)"No Refinements selected. Do you want to cancel the analysis?");
            if (!cancel) {
                return;
            }
        } else {
            VPMRefinementWorkflowConfiguration config = this.buildWorflowConfiguration(refinements);
            VPMRefinementWorkflowDelegate delegate = new VPMRefinementWorkflowDelegate(config);
            WorkflowListenerUtil.runWorkflowAndUpdateUI(delegate, this.getText(), config.getSplevoProjectEditor());
        }
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        page.closeEditor((IEditorPart)this.vpmRefinementBrowser, false);
    }

    protected List<Refinement> getRefinementsFromRefinementBrowser() {
        return this.vpmRefinementBrowser.getRefinementModel().getRefinements();
    }

    private VariationPointModel extractVPM(List<Refinement> refinements) {
        for (Refinement refinement : refinements) {
            EList vps = refinement.getVariationPoints();
            if (vps.size() > 0) {
                VariationPointGroup group = (VariationPointGroup)((VariationPoint)vps.get(0)).eContainer();
                VariationPointModel model = (VariationPointModel)group.eContainer();
                return model;
            }
            VariationPointModel vpm = this.extractVPM((List<Refinement>)refinement.getSubRefinements());
            if (vpm == null) continue;
            return vpm;
        }
        return null;
    }

    public ImageDescriptor getImageDescriptor() {
        return SPLevoUIPlugin.getImageDescriptor("icons/apply-refinements.gif");
    }

    private VPMRefinementWorkflowConfiguration buildWorflowConfiguration(List<Refinement> refinements) {
        VPMRefinementWorkflowConfiguration config = new VPMRefinementWorkflowConfiguration();
        config.setSplevoProjectEditor(this.vpmRefinementBrowser.getSPLevoProjectEditor());
        config.getRefinements().addAll(refinements);
        VariationPointModel model = this.extractVPM(refinements);
        config.setVariationPointModel(model);
        return config;
    }
}

