/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.ui.sourceconnection;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.splevo.project.SPLevoProject;
import org.splevo.ui.sourceconnection.UnifiedDiffConnectorModel;
import org.splevo.ui.sourceconnection.helper.IndexedLineNumber;
import org.splevo.ui.sourceconnection.helper.NumbersTextPair;
import org.splevo.vpm.variability.Variant;

public class UnifiedDiffConnector {
    private final UnifiedDiffConnectorModel diffModel;

    public UnifiedDiffConnector(SPLevoProject splevoProject, Set<Variant> variants, File unifiedDiffFile, String fileName) {
        this.diffModel = new UnifiedDiffConnectorModel(splevoProject, variants, unifiedDiffFile, fileName);
    }

    public void calculateDifference(DiffMethod diffMethod) {
        switch (diffMethod) {
            case BY_LINE: {
                this.calculateByLine();
                break;
            }
            case BY_BLOCKS: {
                this.calculateByBlocks();
                break;
            }
            default: {
                this.calculateByBlocks();
            }
        }
    }

    private void calculateByBlocks() {
        List<NumbersTextPair> unifiedLinesToRead = this.diffModel.getLeadingCopy();
        List<String[]> integrations = this.diffModel.getIntegrationCopies();
        for (String[] integration : integrations) {
            ArrayList<NumbersTextPair> unifiedLinesToWrite = new ArrayList<NumbersTextPair>();
            int leadingLines = unifiedLinesToRead.size();
            int integrationLines = integration.length;
            int integrationColumnIndex = integrations.indexOf(integration) + 1;
            int[][] lcs = this.computeLCSTable(unifiedLinesToRead, integration);
            int i = 0;
            int j = 0;
            while (i < leadingLines && j < integrationLines) {
                ArrayList<IndexedLineNumber> lineNumbers;
                String leadingLine = unifiedLinesToRead.get(i).getLineText();
                if (leadingLine.equals(integration[j])) {
                    lineNumbers = new ArrayList<IndexedLineNumber>();
                    lineNumbers.addAll(unifiedLinesToRead.get(i).getLineNumbers());
                    lineNumbers.add(new IndexedLineNumber(integrationColumnIndex, j + 1));
                    unifiedLinesToWrite.add(new NumbersTextPair(lineNumbers, leadingLine));
                    ++i;
                    ++j;
                    continue;
                }
                if (lcs[i + 1][j] >= lcs[i][j + 1]) {
                    lineNumbers = new ArrayList();
                    lineNumbers.addAll(unifiedLinesToRead.get(i).getLineNumbers());
                    unifiedLinesToWrite.add(new NumbersTextPair(lineNumbers, leadingLine));
                    ++i;
                    continue;
                }
                lineNumbers = new ArrayList();
                lineNumbers.add(new IndexedLineNumber(integrationColumnIndex, j + 1));
                unifiedLinesToWrite.add(new NumbersTextPair(lineNumbers, integration[j]));
                ++j;
            }
            while (i < leadingLines || j < integrationLines) {
                ArrayList<IndexedLineNumber> lineNumbers;
                if (j == integrationLines) {
                    lineNumbers = new ArrayList<IndexedLineNumber>();
                    lineNumbers.addAll(unifiedLinesToRead.get(i).getLineNumbers());
                    unifiedLinesToWrite.add(new NumbersTextPair(lineNumbers, unifiedLinesToRead.get(i).getLineText()));
                    ++i;
                    continue;
                }
                if (i != leadingLines) continue;
                lineNumbers = new ArrayList();
                lineNumbers.add(new IndexedLineNumber(integrationColumnIndex, j + 1));
                unifiedLinesToWrite.add(new NumbersTextPair(lineNumbers, integration[j]));
                ++j;
            }
            unifiedLinesToRead = unifiedLinesToWrite;
        }
        unifiedLinesToRead = this.postProcess(unifiedLinesToRead);
        this.diffModel.setUnifiedLines(unifiedLinesToRead);
    }

    private int[][] computeLCSTable(List<NumbersTextPair> firstSet, String[] secondSet) {
        int firstSetLineCount = firstSet.size();
        int secondSetLineCount = secondSet.length;
        int[][] lcs = new int[firstSetLineCount + 1][secondSetLineCount + 1];
        int i = firstSetLineCount - 1;
        while (i >= 0) {
            int j = secondSetLineCount - 1;
            while (j >= 0) {
                lcs[i][j] = firstSet.get(i).getLineText().equals(secondSet[j]) ? lcs[i + 1][j + 1] + 1 : Math.max(lcs[i + 1][j], lcs[i][j + 1]);
                --j;
            }
            --i;
        }
        return lcs;
    }

    private void calculateByLine() {
        List<NumbersTextPair> unifiedLinesToRead = this.diffModel.getLeadingCopy();
        List<String[]> integrations = this.diffModel.getIntegrationCopies();
        for (String[] integration : integrations) {
            ArrayList<NumbersTextPair> unifiedLinesToWrite = new ArrayList<NumbersTextPair>();
            int leadingLines = unifiedLinesToRead.size();
            int integrationLines = integration.length;
            int integrationColumnIndex = integrations.indexOf(integration) + 1;
            int i = 0;
            int j = 0;
            while (i < leadingLines && j < integrationLines) {
                boolean isLastLeadingLine;
                ArrayList<IndexedLineNumber> lineNumbers;
                String leadingLine = unifiedLinesToRead.get(i).getLineText();
                if (leadingLine.equals(integration[j])) {
                    lineNumbers = new ArrayList<IndexedLineNumber>();
                    lineNumbers.addAll(unifiedLinesToRead.get(i).getLineNumbers());
                    lineNumbers.add(new IndexedLineNumber(integrationColumnIndex, j + 1));
                    unifiedLinesToWrite.add(new NumbersTextPair(lineNumbers, leadingLine));
                    ++i;
                    ++j;
                    continue;
                }
                lineNumbers = new ArrayList();
                lineNumbers.addAll(unifiedLinesToRead.get(i).getLineNumbers());
                unifiedLinesToWrite.add(new NumbersTextPair(lineNumbers, leadingLine));
                boolean bl = isLastLeadingLine = i == leadingLines - 1;
                if (isLastLeadingLine) {
                    lineNumbers = new ArrayList();
                    lineNumbers.add(new IndexedLineNumber(integrationColumnIndex, j + 1));
                    unifiedLinesToWrite.add(new NumbersTextPair(lineNumbers, integration[j]));
                    ++j;
                } else {
                    boolean nextLeadingLineHasSEQLineNumer = false;
                    if (i + 1 < leadingLines) {
                        for (IndexedLineNumber lineNumber : unifiedLinesToRead.get(i + 1).getLineNumbers()) {
                            if (lineNumber.getNumber() > j) continue;
                            nextLeadingLineHasSEQLineNumer = true;
                            break;
                        }
                    }
                    if (!nextLeadingLineHasSEQLineNumer) {
                        lineNumbers = new ArrayList();
                        lineNumbers.add(new IndexedLineNumber(integrationColumnIndex, j + 1));
                        unifiedLinesToWrite.add(new NumbersTextPair(lineNumbers, integration[j]));
                        ++j;
                    }
                }
                ++i;
            }
            while (i < leadingLines || j < integrationLines) {
                ArrayList<IndexedLineNumber> lineNumbers;
                if (j == integrationLines) {
                    lineNumbers = new ArrayList<IndexedLineNumber>();
                    lineNumbers.addAll(unifiedLinesToRead.get(i).getLineNumbers());
                    unifiedLinesToWrite.add(new NumbersTextPair(lineNumbers, unifiedLinesToRead.get(i).getLineText()));
                    ++i;
                    continue;
                }
                if (i != leadingLines) continue;
                lineNumbers = new ArrayList();
                lineNumbers.add(new IndexedLineNumber(integrationColumnIndex, j + 1));
                unifiedLinesToWrite.add(new NumbersTextPair(lineNumbers, integration[j]));
                ++j;
            }
            unifiedLinesToRead = unifiedLinesToWrite;
        }
        unifiedLinesToRead = this.postProcess(unifiedLinesToRead);
        this.diffModel.setUnifiedLines(unifiedLinesToRead);
    }

    private List<NumbersTextPair> postProcess(List<NumbersTextPair> unifiedLines) {
        ArrayList<NumbersTextPair> unifiedLinesToWrite = new ArrayList<NumbersTextPair>(unifiedLines);
        for (NumbersTextPair unifiedLine : unifiedLines) {
            if (unifiedLine.getLineNumbers().size() <= 1 || !this.diffModel.hasVPsFor(unifiedLine.getLineNumbers())) continue;
            int index = unifiedLines.indexOf(unifiedLine);
            String sharedLineText = unifiedLines.get(index).getLineText();
            List<IndexedLineNumber> iLineNumbers = unifiedLine.getLineNumbers();
            unifiedLinesToWrite.remove(index);
            for (IndexedLineNumber iLineNumber : iLineNumbers) {
                ArrayList<IndexedLineNumber> lineNumbers = new ArrayList<IndexedLineNumber>();
                lineNumbers.add(new IndexedLineNumber(iLineNumber.getColumnIndex(), iLineNumber.getNumber()));
                unifiedLinesToWrite.add(index, new NumbersTextPair(lineNumbers, sharedLineText));
                ++index;
            }
        }
        return unifiedLinesToWrite;
    }

    public UnifiedDiffConnectorModel getDiffConnectorModel() {
        return this.diffModel;
    }

    public String getUnifiedText() {
        StringBuilder builder = new StringBuilder();
        for (String string : this.diffModel.getUnifiedTextLines()) {
            builder.append(String.valueOf(string) + "\n");
        }
        return builder.toString();
    }

    public String getProccessedFileName() {
        return this.diffModel.getProccessedFileName();
    }

    public static enum DiffMethod {
        BY_BLOCKS,
        BY_LINE;

    }
}

