/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.ui.sourceconnection.handler;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.splevo.ui.vpexplorer.providers.VPExplorerContentProvider;
import org.splevo.vpm.refinement.Refinement;
import org.splevo.vpm.variability.Variant;
import org.splevo.vpm.variability.VariationPoint;

public abstract class OpenSourceHandlerBase
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchPart sendingPart = HandlerUtil.getActivePart((ExecutionEvent)event);
        ISelection curSelection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (curSelection != null && curSelection instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)curSelection;
            HashSet<Variant> variants = new HashSet<Variant>();
            LinkedList<Object> queue = new LinkedList<Object>(selection.toList());
            while (!queue.isEmpty()) {
                Object selectedItem = queue.remove(0);
                if (selectedItem instanceof Variant) {
                    variants.add((Variant)selectedItem);
                    continue;
                }
                if (selectedItem instanceof VariationPoint) {
                    queue.addAll((Collection<Object>)((VariationPoint)selectedItem).getVariants());
                    continue;
                }
                if (selectedItem instanceof Refinement) {
                    Refinement refinement = (Refinement)selectedItem;
                    queue.addAll((Collection<Object>)refinement.getSubRefinements());
                    queue.addAll((Collection<Object>)refinement.getVariationPoints());
                    continue;
                }
                if (!(selectedItem instanceof VPExplorerContentProvider.VPExplorerContentFileWithChildReference)) continue;
                VPExplorerContentProvider.VPExplorerContentFileWithChildReference file = (VPExplorerContentProvider.VPExplorerContentFileWithChildReference)selectedItem;
                queue.addAll(Arrays.asList(file.getVPMChildren()));
            }
            this.handle(variants, sendingPart);
        }
        return null;
    }

    protected abstract void handle(Set<Variant> var1, IWorkbenchPart var2);
}

