/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.ui.views.vpmgraph;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Panel;
import java.util.Random;
import javax.swing.JRootPane;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.part.ViewPart;
import org.graphstream.graph.Graph;
import org.graphstream.stream.ProxyPipe;
import org.graphstream.ui.layout.Layout;
import org.graphstream.ui.layout.springbox.implementations.SpringBox;
import org.graphstream.ui.swingViewer.View;
import org.graphstream.ui.swingViewer.Viewer;
import org.splevo.ui.views.vpmgraph.CustomEdgeLabelAttributeProxy;
import org.splevo.ui.views.vpmgraph.FilterSingleNodeAction;
import org.splevo.ui.views.vpmgraph.HideEdgeLabelAction;
import org.splevo.vpm.analyzer.graph.VPMGraph;

public class VPMGraphView
extends ViewPart {
    public static final String ID = "org.splevo.ui.viewer.vpmgraph.VPMGraphViewer";
    private VPMGraph vpmGraph = null;
    private final FormToolkit formToolkit = new FormToolkit(Display.getDefault());
    private Frame frame = null;
    private FilterSingleNodeAction filterSingleNodesAction;
    private HideEdgeLabelAction hideEdgeLabelAction;

    public void showGraph(VPMGraph graph) {
        this.createGraphViewer(graph);
    }

    private void createGraphViewer(VPMGraph graph) {
        this.vpmGraph = graph;
        this.setTitleToolTip("Graph: " + graph.getId());
        CustomEdgeLabelAttributeProxy proxy = new CustomEdgeLabelAttributeProxy((Graph)this.vpmGraph, "vp.relationship.label");
        Viewer v = new Viewer((ProxyPipe)proxy);
        SpringBox layout = new SpringBox(false, new Random(0L));
        v.enableAutoLayout((Layout)layout);
        v.setCloseFramePolicy(Viewer.CloseFramePolicy.HIDE_ONLY);
        View view = v.addDefaultView(false);
        view.setFocusTraversalKeysEnabled(true);
        Panel panel = new Panel(new BorderLayout()){
            private static final long serialVersionUID = 1L;

            @Override
            public void update(Graphics g) {
                this.paint(g);
            }
        };
        JRootPane root = new JRootPane();
        panel.add(root);
        root.getContentPane().add((Component)view);
        this.frame.add(panel);
        this.frame.setVisible(true);
        this.setFocus();
    }

    public void createPartControl(Composite parent) {
        Composite composite = new Composite(parent, 0x1040000);
        this.formToolkit.adapt(composite);
        this.formToolkit.paintBordersFor(composite);
        this.frame = SWT_AWT.new_Frame((Composite)composite);
        this.createActions();
        this.initializeToolBar();
        this.initializeMenu();
    }

    private void createActions() {
        this.filterSingleNodesAction = new FilterSingleNodeAction(this);
        this.hideEdgeLabelAction = new HideEdgeLabelAction(this);
    }

    private void initializeToolBar() {
        IToolBarManager toolbarManager = this.getViewSite().getActionBars().getToolBarManager();
        toolbarManager.add((IAction)this.filterSingleNodesAction);
        toolbarManager.add((IAction)this.hideEdgeLabelAction);
    }

    private void initializeMenu() {
        IMenuManager menuManager = this.getViewSite().getActionBars().getMenuManager();
    }

    public void setFocus() {
    }

    public VPMGraph getVpmGraph() {
        return this.vpmGraph;
    }
}

