/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.ui.wizards.vpmanalysis;

import java.util.List;
import java.util.Map;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.splevo.ui.util.UIUtil;
import org.splevo.vpm.analyzer.VPMAnalyzer;
import org.splevo.vpm.analyzer.config.AbstractVPMAnalyzerConfiguration;
import org.splevo.vpm.analyzer.config.BooleanConfiguration;
import org.splevo.vpm.analyzer.config.ChoiceConfiguration;
import org.splevo.vpm.analyzer.config.NumericConfiguration;
import org.splevo.vpm.analyzer.config.StringConfiguration;
import org.splevo.vpm.analyzer.config.VPMAnalyzerConfigurationSet;

public class UIConfigurationCompositeFactory {
    private VPMAnalyzer analyzer;

    public UIConfigurationCompositeFactory(VPMAnalyzer analyzer) {
        this.analyzer = analyzer;
    }

    public void createConfigComps(Composite parent) {
        VPMAnalyzerConfigurationSet configurations = this.analyzer.getConfigurations();
        Map configsByGroupName = configurations.getAllConfigurationsByGroupName();
        for (String groupName : configsByGroupName.keySet()) {
            this.createConfigurationGroup(parent, groupName, (List)configsByGroupName.get(groupName));
        }
    }

    private void createConfigurationGroup(Composite parent, String groupName, List<AbstractVPMAnalyzerConfiguration<?>> configs) {
        Group group = new Group(parent, 0);
        group.setText(groupName);
        GridLayout groupGridLayout = new GridLayout(1, true);
        groupGridLayout.verticalSpacing = 0;
        group.setLayout((Layout)groupGridLayout);
        FormData formData = new FormData();
        if (parent.getChildren().length == 1) {
            formData.top = new FormAttachment(0);
        } else {
            Control lastGroup = parent.getChildren()[parent.getChildren().length - 2];
            formData.top = new FormAttachment(lastGroup, 10);
        }
        formData.left = new FormAttachment(0);
        formData.right = new FormAttachment(100);
        group.setLayoutData((Object)formData);
        for (AbstractVPMAnalyzerConfiguration<?> config : configs) {
            Composite parentComp = new Composite((Composite)group, 4);
            parentComp.setLayoutData((Object)new GridData(4, -1, true, false));
            GridLayout parentCompLayout = new GridLayout(3, false);
            parentCompLayout.verticalSpacing = 0;
            parentComp.setLayout((Layout)parentCompLayout);
            if (config instanceof BooleanConfiguration) {
                this.createBooleanConfigField(parentComp, (BooleanConfiguration)config);
                continue;
            }
            if (config instanceof StringConfiguration) {
                this.createStringConfigField(parentComp, (StringConfiguration)config);
                continue;
            }
            if (config instanceof ChoiceConfiguration) {
                this.createChoiceConfigField(parentComp, (ChoiceConfiguration)config);
                continue;
            }
            if (!(config instanceof NumericConfiguration)) continue;
            this.createNumericConfigField(parentComp, (NumericConfiguration)config);
        }
    }

    private void createNumericConfigField(Composite parent, final NumericConfiguration config) {
        boolean decimalPlaces = false;
        this.addLabel(parent, config.getLabel(), false);
        final Spinner spinner = new Spinner(parent, 0);
        spinner.setIncrement(config.getStepSize());
        spinner.setDigits(0);
        spinner.setMinimum(config.getLowerBoundary());
        spinner.setMaximum(config.getUpperBoundary());
        config.setCurrentValue((Object)((Integer)config.getDefaultValue()));
        spinner.setSelection(((Integer)config.getDefaultValue()).intValue());
        spinner.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                int spinnerValue = spinner.getSelection();
                config.setCurrentValue((Object)spinnerValue);
            }
        });
        GridData layoutData = new GridData(1, 0x1000000, true, false);
        layoutData.widthHint = 50;
        spinner.setLayoutData((Object)layoutData);
        UIUtil.addExplanation(parent, config.getExplanation());
    }

    private void createChoiceConfigField(Composite parent, final ChoiceConfiguration config) {
        this.addLabel(parent, config.getLabel(), false);
        final List labels = config.getAvailableValues();
        final Combo combo = new Combo(parent, 76);
        combo.setItems(labels.toArray(new String[0]));
        config.setCurrentValue((String)config.getDefaultValue());
        combo.select(labels.indexOf(config.getDefaultValue()));
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                String selectedValue = (String)labels.get(combo.getSelectionIndex());
                config.setCurrentValue(selectedValue);
            }
        });
        combo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        UIUtil.addExplanation(parent, config.getExplanation());
    }

    private void createStringConfigField(Composite parent, final StringConfiguration config) {
        this.addLabel(parent, config.getLabel(), false);
        final StyledText text = new StyledText(parent, 2560);
        text.setLeftMargin(2);
        text.setRightMargin(2);
        text.setTopMargin(2);
        text.setBottomMargin(2);
        text.setWordWrap(true);
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                config.setCurrentValue((Object)text.getText());
            }
        });
        String defaultText = (String)config.getDefaultValue();
        config.setCurrentValue((Object)defaultText);
        text.setText(defaultText);
        GridData layoutData = new GridData(4, 4, true, true);
        layoutData.widthHint = 4;
        layoutData.heightHint = config.isSingleLine() ? 16 : 80;
        text.setLayoutData((Object)layoutData);
        UIUtil.addExplanation(parent, config.getExplanation());
    }

    private void createBooleanConfigField(Composite parent, final BooleanConfiguration config) {
        final Button checkButton = new Button(parent, 32);
        checkButton.setSelection(((Boolean)config.getDefaultValue()).booleanValue());
        config.setCurrentValue((Object)((Boolean)config.getDefaultValue()));
        checkButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                config.setCurrentValue((Object)checkButton.getSelection());
            }
        });
        this.addLabel(parent, config.getLabel(), true);
        UIUtil.addExplanation(parent, config.getExplanation());
    }

    private void addLabel(Composite parent, String text, boolean grabHorizontalSpace) {
        Label label = new Label(parent, 64);
        label.setText(text);
        label.setLayoutData((Object)new GridData(1, 0x1000000, grabHorizontalSpace, false));
    }
}

