/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.ui.wizards.vpmanalysis;

import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.splevo.ui.jobs.SPLevoBlackBoard;
import org.splevo.ui.listeners.WorkflowListenerUtil;
import org.splevo.ui.refinementbrowser.OpenRefinementBrowserRunnable;
import org.splevo.ui.views.vpmgraph.OpenVPMGraphViewerRunnable;
import org.splevo.ui.wizards.vpmanalysis.ResultHandlingConfigurationPage;
import org.splevo.ui.wizards.vpmanalysis.VPMAnalyzerConfigurationPage;
import org.splevo.ui.workflow.VPMAnalysisWorkflowConfiguration;
import org.splevo.ui.workflow.VPMAnalysisWorkflowDelegate;
import org.splevo.vpm.analyzer.VPMAnalyzer;

public class VPMAnalysisWizard
extends Wizard {
    private Logger logger = Logger.getLogger(VPMAnalysisWizard.class);
    private VPMAnalyzerConfigurationPage analyzerPage = null;
    private ResultHandlingConfigurationPage resultHandlingPage = null;
    private VPMAnalysisWorkflowConfiguration analysisWorkflowConfiguration = null;

    public VPMAnalysisWizard(VPMAnalysisWorkflowConfiguration configuration) {
        this.analysisWorkflowConfiguration = configuration;
        this.setWindowTitle("Configure VPM Analysis.");
        this.setNeedsProgressMonitor(false);
    }

    public void addPages() {
        this.analyzerPage = new VPMAnalyzerConfigurationPage();
        this.resultHandlingPage = new ResultHandlingConfigurationPage(this.analysisWorkflowConfiguration);
        this.addPage((IWizardPage)this.analyzerPage);
        this.addPage((IWizardPage)this.resultHandlingPage);
    }

    public boolean canFinish() {
        if (this.analyzerPage.getAnalyzers().size() < 1) {
            return false;
        }
        return this.resultHandlingPage.getDetectionRules().size() >= 1;
    }

    public boolean performFinish() {
        this.updateConfiguration();
        if (!this.analysisWorkflowConfiguration.isValid()) {
            return false;
        }
        if (this.getContainer().getCurrentPage().equals((Object)this.resultHandlingPage)) {
            switch (this.analysisWorkflowConfiguration.getPresentation()) {
                case RELATIONSHIP_GRAPH_ONLY: {
                    this.runAnalysisAndOpenVPMGraphViewer();
                    break;
                }
                case REFINEMENT_BROWSER: {
                    this.runAnalysisAndOpenRefinementEditor();
                    break;
                }
                default: {
                    this.logger.error((Object)"Invalid result handling option");
                }
            }
        }
        return true;
    }

    private void runAnalysisAndOpenRefinementEditor() {
        SPLevoBlackBoard spLevoBlackBoard = new SPLevoBlackBoard();
        OpenRefinementBrowserRunnable openRefinementEditorRunnable = new OpenRefinementBrowserRunnable(this.analysisWorkflowConfiguration.getSplevoProjectEditor(), spLevoBlackBoard);
        VPMAnalysisWorkflowDelegate delegate = new VPMAnalysisWorkflowDelegate(this.analysisWorkflowConfiguration, spLevoBlackBoard, true);
        WorkflowListenerUtil.runWorkflowAndRunUITask(delegate, "Analyze VPM", openRefinementEditorRunnable);
    }

    private void runAnalysisAndOpenVPMGraphViewer() {
        SPLevoBlackBoard spLevoBlackBoard = new SPLevoBlackBoard();
        OpenVPMGraphViewerRunnable openGraphRunnable = new OpenVPMGraphViewerRunnable(spLevoBlackBoard);
        VPMAnalysisWorkflowDelegate delegate = new VPMAnalysisWorkflowDelegate(this.analysisWorkflowConfiguration, spLevoBlackBoard, false);
        WorkflowListenerUtil.runWorkflowAndRunUITask(delegate, "Analyze VPM", openGraphRunnable);
    }

    public void updateConfiguration() {
        List<VPMAnalyzer> analyzers = this.analyzerPage.getAnalyzers();
        this.analysisWorkflowConfiguration.getAnalyzers().clear();
        this.analysisWorkflowConfiguration.getAnalyzers().addAll(analyzers);
        VPMAnalysisWorkflowConfiguration.ResultPresentation resultPresentation = this.resultHandlingPage.getResultPresentation();
        this.analysisWorkflowConfiguration.setPresentation(resultPresentation);
        this.analysisWorkflowConfiguration.getDetectionRules().clear();
        this.analysisWorkflowConfiguration.getDetectionRules().addAll(this.resultHandlingPage.getDetectionRules());
        this.analysisWorkflowConfiguration.setUseMergeDetection(this.resultHandlingPage.isUseMergeDetection());
        this.analysisWorkflowConfiguration.setFullRefinementReasons(this.resultHandlingPage.isFullRefinementReasons());
    }

    public VPMAnalysisWorkflowConfiguration getAnalysisWorkflowConfiguration() {
        this.updateConfiguration();
        return this.analysisWorkflowConfiguration;
    }
}

