/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.ui.dashboard;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.wb.swt.ResourceManager;
import org.mihalis.opal.header.Header;
import org.mihalis.opal.itemSelector.DLItem;
import org.mihalis.opal.itemSelector.DualList;
import org.mihalis.opal.itemSelector.SelectionChangeEvent;
import org.mihalis.opal.itemSelector.SelectionChangeListener;
import org.splevo.project.ProjectFactory;
import org.splevo.project.SPLProfile;
import org.splevo.refactoring.VariabilityRefactoring;
import org.splevo.refactoring.VariabilityRefactoringRegistry;
import org.splevo.ui.dashboard.AbstractDashboardTab;
import org.splevo.ui.editors.SPLevoProjectEditor;
import org.splevo.vpm.realization.VariabilityMechanism;

public class SPLProfileTab
extends AbstractDashboardTab {
    private static final String SPLPROFILE_CONFIG_ID_REFACTORING_DATA = "refactoring";

    public SPLProfileTab(SPLevoProjectEditor splevoProjectEditor, TabFolder tabFolder, int tabIndex) {
        super(splevoProjectEditor);
        this.createTab(tabFolder, tabIndex);
    }

    private void createTab(TabFolder tabFolder, int tabIndex) {
        TabItem configurationTab = new TabItem(tabFolder, 0, tabIndex);
        configurationTab.setText("SPL Profile");
        ScrolledComposite scrolledComposite = new ScrolledComposite((Composite)tabFolder, 512);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        configurationTab.setControl((Control)scrolledComposite);
        Composite composite = new Composite((Composite)scrolledComposite, 4);
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setLayoutData((Object)new GridData(4, 2, true, false));
        this.createHeader(composite);
        this.createQualityGoalGroup(composite);
        this.createMechanismGroup(composite);
        scrolledComposite.setContent((Control)composite);
        scrolledComposite.setMinSize(composite.computeSize(-1, -1));
    }

    private void createQualityGoalGroup(Composite composite) {
        Group qualityGoalGroup = new Group(composite, 4);
        qualityGoalGroup.setText("Quality Goals");
        qualityGoalGroup.setFont(this.getModifiedFont((Control)qualityGoalGroup, 1));
        qualityGoalGroup.setLayout((Layout)new GridLayout(1, false));
        qualityGoalGroup.setLayoutData((Object)new GridData(768));
        Label selectionInfo = new Label((Composite)qualityGoalGroup, 0);
        selectionInfo.setText("Area for specifying SPL quality goals relevant for the consolidation process.");
    }

    private void createMechanismGroup(Composite composite) {
        Group mechanismGroup = new Group(composite, 4);
        mechanismGroup.setText("Variability Mechanisms");
        mechanismGroup.setFont(this.getModifiedFont((Control)mechanismGroup, 1));
        mechanismGroup.setLayout((Layout)new GridLayout(1, false));
        mechanismGroup.setLayoutData((Object)new GridData(768));
        Label selectionInfo = new Label((Composite)mechanismGroup, 0);
        selectionInfo.setText("Select the variability mechanisms to be used in the target product line.\r\nLeft: available ones, Right: selected ones. The order defines the priority");
        DualList dl = new DualList((Composite)mechanismGroup, 2056);
        dl.setLayoutData(new GridData(4, 4, true, true));
        dl.addSelectionChangeListener(new SelectionChangeListener(){

            public void widgetSelected(SelectionChangeEvent e) {
                boolean modified = false;
                for (DLItem item : e.getItems()) {
                    Object data = item.getData(SPLProfileTab.SPLPROFILE_CONFIG_ID_REFACTORING_DATA);
                    if (!(data instanceof VariabilityRefactoring)) continue;
                    VariabilityRefactoring refactoring = (VariabilityRefactoring)data;
                    EList recommendedRefactoringIds = SPLProfileTab.this.getSPLProfile().getRecommendedRefactoringIds();
                    if (recommendedRefactoringIds.contains((Object)refactoring.getId())) continue;
                    if (item.getLastAction() == DLItem.LAST_ACTION.SELECTION) {
                        recommendedRefactoringIds.add((Object)refactoring.getId());
                    } else {
                        recommendedRefactoringIds.remove((Object)refactoring.getId());
                    }
                    modified = true;
                }
                if (modified) {
                    SPLProfileTab.this.getSplevoProjectEditor().markAsDirty();
                }
            }
        });
        ArrayList items = Lists.newArrayList();
        for (VariabilityRefactoring refactoring : VariabilityRefactoringRegistry.getInstance().getElements()) {
            VariabilityMechanism mechanism = refactoring.getVariabilityMechanism();
            DLItem item = new DLItem(mechanism.getName());
            item.setData(SPLPROFILE_CONFIG_ID_REFACTORING_DATA, refactoring);
            items.add(item);
        }
        dl.setItems(items);
        int i = 0;
        while (i < dl.getItemsAsList().size()) {
            DLItem item = dl.getItemsAsList().get(i);
            VariabilityRefactoring refactoring = (VariabilityRefactoring)item.getData(SPLPROFILE_CONFIG_ID_REFACTORING_DATA);
            if (this.getSPLProfile().getRecommendedRefactoringIds().contains((Object)refactoring.getId())) {
                dl.select(i);
            }
            ++i;
        }
        dl.redraw();
        dl.update();
    }

    private void createHeader(Composite composite) {
        Header header = new Header(composite, 0);
        header.setTitle("SPL Profile");
        header.setImage(ResourceManager.getPluginImage("org.splevo.ui", "icons/configure.png"));
        header.setDescription("Product-Line parameters as overarching company or project guidelines.");
        header.setLayoutData((Object)new GridData(4, 2, true, false));
    }

    private Font getModifiedFont(Control control, int style) {
        FontData fontData = control.getFont().getFontData()[0];
        Font modifiedFont = new Font((Device)Display.getCurrent(), new FontData(fontData.getName(), fontData.getHeight(), style));
        return modifiedFont;
    }

    private final SPLProfile getSPLProfile() {
        SPLProfile splProfile = this.getSPLevoProject().getSplProfile();
        if (splProfile == null) {
            splProfile = ProjectFactory.eINSTANCE.createSPLProfile();
            this.getSPLevoProject().setSplProfile(splProfile);
        }
        return splProfile;
    }
}

