/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.ui.editors;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.JFaceTextUtil;
import org.eclipse.jface.text.source.LineNumberRulerColumn;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Display;
import org.splevo.ui.sourceconnection.helper.IndexedLineNumber;

public class UnifiedDiffRulerColumn
extends LineNumberRulerColumn {
    private static final Logger LOGGER = Logger.getLogger(UnifiedDiffRulerColumn.class);
    private static final int COLUMN_RIGHT_MARGIN = 5;
    private int columnIndex;
    private List<List<IndexedLineNumber>> indexedLineNumbersList = new ArrayList<List<IndexedLineNumber>>();
    private Map<Integer, Color> linesToColorMapping;

    public UnifiedDiffRulerColumn(int columnIndex, List<List<IndexedLineNumber>> indexedLineNumbersList, Map<Integer, Color> linesToColorMapping) {
        this.columnIndex = columnIndex;
        this.indexedLineNumbersList = indexedLineNumbersList;
        this.linesToColorMapping = linesToColorMapping;
    }

    protected void paintLine(int line, int y, int lineheight, GC gc, Display display) {
        int widgetLine = JFaceTextUtil.modelLineToWidgetLine((ITextViewer)this.getParentRuler().getTextViewer(), (int)line);
        String text = "";
        Color bgColor = null;
        if (line < this.indexedLineNumbersList.size()) {
            bgColor = this.linesToColorMapping.get(line);
            List<IndexedLineNumber> curLine = this.indexedLineNumbersList.get(line);
            for (IndexedLineNumber lineNumber : curLine) {
                if (lineNumber.getColumnIndex() != this.columnIndex) continue;
                text = this.createDisplayString(lineNumber.getNumber());
            }
        }
        int[] indentations = null;
        try {
            indentations = this.getIndentations();
        }
        catch (Exception e) {
            LOGGER.error((Object)"Could not get unified column line indentation!", (Throwable)e);
        }
        if (indentations != null) {
            int indentation = indentations[text.length()];
            int baselineBias = this.getBaselineBias(gc, widgetLine);
            if (bgColor != null) {
                gc.setBackground(bgColor);
                gc.drawString(text, indentation, y + baselineBias, false);
            } else {
                gc.drawString(text, indentation, y + baselineBias, true);
            }
        }
    }

    private int getBaselineBias(GC gc, int widgetLine) {
        ITextViewer textViewer = this.getParentRuler().getTextViewer();
        int offset = textViewer.getTextWidget().getOffsetAtLine(widgetLine);
        int widgetBaseline = textViewer.getTextWidget().getBaseline(offset);
        FontMetrics fm = gc.getFontMetrics();
        int fontBaseline = fm.getAscent() + fm.getLeading();
        int baselineBias = widgetBaseline - fontBaseline;
        return Math.max(0, baselineBias);
    }

    public String createDisplayString(int line) {
        return Integer.toString(line);
    }

    public int getWidth() {
        int[] indentations = null;
        try {
            indentations = this.getIndentations();
        }
        catch (Exception e) {
            LOGGER.error((Object)"Could not get unified column width!", (Throwable)e);
        }
        return indentations[0] + 5;
    }

    private int[] getIndentations() throws IllegalAccessException, NoSuchFieldException {
        Field privateField = LineNumberRulerColumn.class.getDeclaredField("fIndentation");
        privateField.setAccessible(true);
        int[] indentations = (int[])privateField.get((Object)this);
        privateField.setAccessible(false);
        return indentations;
    }
}

