/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.ui.handler.vpm;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.splevo.vpm.VPMUtil;
import org.splevo.vpm.software.SoftwareElement;
import org.splevo.vpm.variability.Variant;
import org.splevo.vpm.variability.VariationPoint;
import org.splevo.vpm.variability.variabilityFactory;

public class MergeVariationPointsHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Shell activeShell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        boolean proceed = MessageDialog.openConfirm((Shell)activeShell, (String)"Merge Variation Points", (String)"There is no technical check performed if the selected variation points can be merged or not.\nProceed anyway?");
        if (!proceed) {
            return null;
        }
        ISelection curSelection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (curSelection != null && curSelection instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)curSelection;
            LinkedHashSet vpsToMerge = Sets.newLinkedHashSet();
            for (Object selectedItem : selection.toList()) {
                if (!(selectedItem instanceof VariationPoint)) continue;
                vpsToMerge.add((VariationPoint)selectedItem);
            }
            this.mergeVPs(vpsToMerge);
            LinkedHashSet resourcesToSave = Sets.newLinkedHashSet();
            for (VariationPoint vp : vpsToMerge) {
                resourcesToSave.add(vp.eResource());
            }
            this.updateResources(resourcesToSave);
        }
        return null;
    }

    private void mergeVPs(Set<VariationPoint> vpsToMerge) throws ExecutionException {
        VariationPoint survivingVP = vpsToMerge.iterator().next();
        Multimap<String, SoftwareElement> variantSoftwareElements = this.collectSoftwareElementsToMove(vpsToMerge, survivingVP);
        this.buildVariantsInSurvivingVP(survivingVP, variantSoftwareElements);
        for (VariationPoint vp : vpsToMerge) {
            if (vp == survivingVP) continue;
            EcoreUtil.remove((EObject)vp);
        }
    }

    private void buildVariantsInSurvivingVP(VariationPoint survivingVP, Multimap<String, SoftwareElement> variantSoftwareElements) {
        for (String variantID : variantSoftwareElements.keys()) {
            Variant variantForId = VPMUtil.getVariantFromVP((VariationPoint)survivingVP, (String)variantID);
            if (variantForId == null) {
                variantForId = variabilityFactory.eINSTANCE.createVariant();
            }
            variantForId.getImplementingElements().addAll(variantSoftwareElements.get((Object)variantID));
        }
    }

    private Multimap<String, SoftwareElement> collectSoftwareElementsToMove(Set<VariationPoint> vpsToMerge, VariationPoint survivingVP) {
        LinkedListMultimap variantSoftwareElements = LinkedListMultimap.create();
        for (VariationPoint vp : vpsToMerge) {
            if (survivingVP == vp) continue;
            for (Variant variant : vp.getVariants()) {
                variantSoftwareElements.putAll((Object)variant.getId(), (Iterable)variant.getImplementingElements());
            }
        }
        return variantSoftwareElements;
    }

    private void updateResources(Set<Resource> resourcesToSave) throws ExecutionException {
        for (Resource resource : resourcesToSave) {
            if (resource == null) continue;
            try {
                resource.save(null);
            }
            catch (IOException e) {
                throw new ExecutionException("Failed to save modified resource", (Throwable)e);
            }
        }
    }
}

