/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.ui.jobs;

import de.uka.ipd.sdq.workflow.jobs.AbstractBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.jobs.CleanupFailedException;
import de.uka.ipd.sdq.workflow.jobs.JobFailedException;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.splevo.diffing.DefaultDiffingService;
import org.splevo.diffing.DiffingException;
import org.splevo.diffing.DiffingModelUtil;
import org.splevo.project.SPLevoProject;
import org.splevo.ui.commons.util.JobUtil;
import org.splevo.ui.jobs.SPLevoBlackBoard;

public class DiffingJob
extends AbstractBlackboardInteractingJob<SPLevoBlackBoard> {
    private static final int PROGRESS_DIFF_MODEL_SAVE_DONE = 20;
    private static final int PROGRESS_DIFFING_DONE = 100;
    private final SPLevoProject splevoProject;

    public DiffingJob(SPLevoProject splevoProject) {
        this.splevoProject = splevoProject;
    }

    public void execute(IProgressMonitor monitor) throws JobFailedException {
        this.logger.info((Object)"Difference analysis started");
        Map<String, String> options = this.buildDiffingOptions();
        ResourceSet leadingModelDir = ((SPLevoBlackBoard)this.getBlackboard()).getResourceSetLeading();
        ResourceSet integrationModelDir = ((SPLevoBlackBoard)this.getBlackboard()).getResourceSetIntegration();
        EList differIds = this.splevoProject.getDifferIds();
        this.logger.info((Object)String.format("Diffing started at %s", JobUtil.getTimestamp()));
        Comparison comparison = null;
        try {
            DefaultDiffingService diffingService = new DefaultDiffingService();
            comparison = diffingService.diffSoftwareModels((List)differIds, leadingModelDir, integrationModelDir, options);
            monitor.worked(100);
        }
        catch (DiffingException e) {
            throw new JobFailedException("Failed to process diffing.", (Throwable)e);
        }
        this.logger.info((Object)String.format("Diffing finished at %s", JobUtil.getTimestamp()));
        this.logger.info((Object)("Number of differences: " + comparison.getDifferences().size()));
        if (monitor.isCanceled()) {
            monitor.done();
            return;
        }
        if (comparison.eContents().size() == 0) {
            this.logger.info((Object)"No Differences detected.");
            return;
        }
        this.logger.info((Object)"Save Diff Model");
        try {
            String targetPath = String.valueOf(this.splevoProject.getWorkspace()) + "models/diffmodel/diffModel.jamoppdiff";
            DiffingModelUtil.save((Comparison)comparison, (File)new File(targetPath));
            this.splevoProject.setDiffingModelPath(targetPath);
        }
        catch (IOException e) {
            throw new JobFailedException("Failed to save diff model.", (Throwable)e);
        }
        this.logger.info((Object)"Place Diff Model on Blackboard");
        ((SPLevoBlackBoard)this.getBlackboard()).setDiffModel(comparison);
        monitor.worked(20);
        this.refreshWorkspace(monitor);
        this.logger.info((Object)"Difference analysis finished");
    }

    private void refreshWorkspace(IProgressMonitor monitor) {
        try {
            ResourcesPlugin.getWorkspace().getRoot().refreshLocal(1, monitor);
        }
        catch (CoreException e) {
            this.logger.error((Object)"Failed to refresh Workspace", (Throwable)e);
        }
    }

    private Map<String, String> buildDiffingOptions() {
        Map diffingOptions = this.splevoProject.getDifferOptions().map();
        return diffingOptions;
    }

    public String getName() {
        return "Diff source models Job";
    }

    public void cleanup(IProgressMonitor arg0) throws CleanupFailedException {
    }
}

