/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.ui.jobs;

import de.uka.ipd.sdq.workflow.jobs.AbstractBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.jobs.CleanupFailedException;
import de.uka.ipd.sdq.workflow.jobs.JobFailedException;
import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.splevo.fm.builder.FeatureModelBuilder;
import org.splevo.fm.builder.FeatureModelBuilderRegistry;
import org.splevo.fm.builder.FeatureModelWrapper;
import org.splevo.project.SPLevoProject;
import org.splevo.ui.jobs.SPLevoBlackBoard;
import org.splevo.vpm.variability.VariationPointModel;

public class GenerateFeatureModelJob
extends AbstractBlackboardInteractingJob<SPLevoBlackBoard> {
    private static final String MSG_BUILDER_NOT_AVAILABLE = "No feature model builder available for the provided id: %1";
    private SPLevoProject splevoProject;

    public GenerateFeatureModelJob(SPLevoProject splevoProject) {
        this.splevoProject = splevoProject;
    }

    public void execute(IProgressMonitor monitor) throws JobFailedException {
        this.logger.info((Object)"Generate Feature Model");
        VariationPointModel vpm = ((SPLevoBlackBoard)this.getBlackboard()).getVariationPointModel();
        if (vpm == null) {
            throw new JobFailedException("No variation point model available in the blackboard.");
        }
        String targetPath = this.getModelFilePath(this.splevoProject);
        String fmBuilderId = this.splevoProject.getFmBuilderId();
        FeatureModelBuilder currentBuilder = (FeatureModelBuilder)FeatureModelBuilderRegistry.getInstance().getElementById((Object)fmBuilderId);
        if (currentBuilder == null) {
            throw new JobFailedException(String.format(MSG_BUILDER_NOT_AVAILABLE, fmBuilderId));
        }
        final FeatureModelWrapper modelWrapper = currentBuilder.build(vpm, this.splevoProject.getName());
        currentBuilder.save(modelWrapper.getModel(), targetPath);
        if (modelWrapper.isCanBeDisplayed()) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    GenerateFeatureModelJob.this.openFeatureDiagram((FeatureModelWrapper<Object>)modelWrapper);
                }
            });
        }
        if (monitor.isCanceled()) {
            monitor.done();
            return;
        }
        monitor.done();
    }

    private void openFeatureDiagram(FeatureModelWrapper<Object> modelWrapper) {
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            EObject model = (EObject)modelWrapper.getModel();
            URI diagramURI = model.eResource().getURI().trimFileExtension().appendFileExtension("featurediagram");
            activePage.openEditor((IEditorInput)new URIEditorInput(diagramURI), "org.eclipse.featuremodel.diagrameditor.diagrameditor");
        }
        catch (PartInitException e) {
            this.logger.error((Object)"Cannot open Feature Diagram View.", (Throwable)e);
        }
        catch (ClassCastException e) {
            this.logger.error((Object)"Invalid model type.", (Throwable)e);
        }
    }

    private String getModelFilePath(SPLevoProject splevoProject) {
        String path = String.valueOf(splevoProject.getWorkspace()) + "models" + File.separator + "fm" + File.separator;
        return path;
    }

    public String getName() {
        return "Generate Feature Model Job";
    }

    public void cleanup(IProgressMonitor arg0) throws CleanupFailedException {
    }
}

