/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.ui.listeners;

import java.io.File;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.widgets.Shell;
import org.splevo.project.SPLevoProject;
import org.splevo.project.VPMModelReference;
import org.splevo.ui.editors.SPLevoProjectEditor;
import org.splevo.ui.listeners.WorkflowListenerUtil;
import org.splevo.ui.workflow.BasicSPLevoWorkflowConfiguration;
import org.splevo.ui.workflow.InitVPMWorkflowDelegate;

public class InitVPMListener
extends MouseAdapter {
    private SPLevoProjectEditor splevoProjectEditor = null;

    public InitVPMListener(SPLevoProjectEditor splevoProjectEditor) {
        this.splevoProjectEditor = splevoProjectEditor;
    }

    public void mouseUp(MouseEvent e) {
        BasicSPLevoWorkflowConfiguration config = this.buildWorflowConfiguration();
        Shell shell = e.widget.getDisplay().getActiveShell();
        if (!config.isValid()) {
            MessageDialog.openError((Shell)shell, (String)"Invalid Project Configuration", (String)config.getErrorMessage());
            return;
        }
        if (config.getSplevoProjectEditor().getSplevoProject().getVpmModelReferences().size() > 0) {
            boolean proceed = MessageDialog.openConfirm((Shell)shell, (String)"Override existing VPMs", (String)"There are existing VPMs. Initializing a new one will override those existing ones.Do you want to proceed?");
            if (!proceed) {
                return;
            }
            this.deleteVPMs(config.getSplevoProjectEditor().getSplevoProject());
        }
        InitVPMWorkflowDelegate delegate = new InitVPMWorkflowDelegate(config);
        String title = "Init VPM";
        WorkflowListenerUtil.runWorkflowAndUpdateUI(delegate, title, this.splevoProjectEditor);
    }

    private void deleteVPMs(SPLevoProject splevoProject) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        String basePath = workspace.getRoot().getRawLocation().toOSString();
        for (VPMModelReference vpmReference : splevoProject.getVpmModelReferences()) {
            String modelPath = String.valueOf(basePath) + vpmReference.getPath();
            new File(modelPath).delete();
        }
        splevoProject.getVpmModelReferences().clear();
    }

    private BasicSPLevoWorkflowConfiguration buildWorflowConfiguration() {
        BasicSPLevoWorkflowConfiguration config = new BasicSPLevoWorkflowConfiguration();
        config.setSplevoProjectEditor(this.splevoProjectEditor);
        return config;
    }
}

