/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.ui.listeners;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.splevo.project.SPLProfile;
import org.splevo.project.SPLevoProject;
import org.splevo.project.VPMModelReference;
import org.splevo.refactoring.RecommenderResult;
import org.splevo.refactoring.VariabilityRefactoring;
import org.splevo.refactoring.VariabilityRefactoringRegistry;
import org.splevo.refactoring.VariabilityRefactoringService;
import org.splevo.ui.commons.util.JobUtil;
import org.splevo.ui.editors.SPLevoProjectEditor;
import org.splevo.ui.jobs.SPLevoBlackBoard;
import org.splevo.ui.listeners.WorkflowListenerUtil;
import org.splevo.ui.workflow.BuildSPLWorkflowConfiguration;
import org.splevo.ui.workflow.BuildSPLWorkflowDelegate;
import org.splevo.ui.workflow.VPMReloadWorkflowDelegate;
import org.splevo.vpm.VPMUtil;
import org.splevo.vpm.variability.VariationPoint;
import org.splevo.vpm.variability.VariationPointGroup;
import org.splevo.vpm.variability.VariationPointModel;

public class StartRefactoringListener
extends MouseAdapter {
    private static Logger logger = Logger.getLogger(StartRefactoringListener.class);
    private SPLevoProjectEditor splevoProjectEditor = null;

    public StartRefactoringListener(SPLevoProjectEditor splevoProjectEditor) {
        this.splevoProjectEditor = splevoProjectEditor;
    }

    public void mouseUp(MouseEvent e) {
        if (!this.checkVPMExists()) {
            return;
        }
        VariationPointModel vpm = this.loadVPM();
        if (vpm == null) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Failed to load VPM", (String)"Unable to laod the latest VPM");
            return;
        }
        boolean vpmReady = this.checkAllMechanismsSelected(vpm);
        if (!vpmReady) {
            boolean executeRecommender = this.askForRecommenderExecution();
            if (executeRecommender) {
                this.executeRecommender(vpm);
            }
            return;
        }
        this.startRefactoring();
    }

    private boolean askForRecommenderExecution() {
        boolean executeRecommender = MessageDialog.openConfirm((Shell)this.getShell(), (String)"Execute Recommender", (String)"Not all variation points have a variability mechanism defined, yet. Do you want to start the auto recommender?");
        return executeRecommender;
    }

    private Shell getShell() {
        Shell shell = Display.getCurrent().getActiveShell();
        return shell;
    }

    private void startRefactoring() {
        SPLevoBlackBoard spLevoBlackBoard = new SPLevoBlackBoard();
        String splPath = String.valueOf(this.splevoProjectEditor.getSplevoProject().getWorkspace()) + "RefactoredSPL";
        BuildSPLWorkflowConfiguration configuration = new BuildSPLWorkflowConfiguration(splPath);
        configuration.setSplevoProjectEditor(this.splevoProjectEditor);
        BuildSPLWorkflowDelegate buildSPLWorkflowConfiguration = new BuildSPLWorkflowDelegate(configuration, spLevoBlackBoard);
        WorkflowListenerUtil.runWorkflowAndUpdateUI(buildSPLWorkflowConfiguration, "Refactor VPM", this.splevoProjectEditor);
    }

    private boolean executeRecommender(VariationPointModel vpm) {
        VariabilityRefactoringService service = new VariabilityRefactoringService();
        SPLProfile splProfile = this.splevoProjectEditor.getSplevoProject().getSplProfile();
        EList refactoringIds = splProfile.getRecommendedRefactoringIds();
        if (refactoringIds == null || refactoringIds.size() == 0) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)"No refactorings configured", (String)"There are no refactorings for introducing variability mechanisms configured yet.Please check your SPL Profile.");
            return false;
        }
        List<VariabilityRefactoring> refactorings = this.getRefactorings((List<String>)refactoringIds);
        RecommenderResult result = service.recommendMechanisms(vpm, refactorings);
        VPMReloadWorkflowDelegate reloadVPMWorkflowDelegate = new VPMReloadWorkflowDelegate(this.splevoProjectEditor);
        WorkflowListenerUtil.runWorkflowAndRunUITask(reloadVPMWorkflowDelegate, "Reload VPM", null);
        if (result.getUnassignedVariationPoints().isEmpty()) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)"Recommender Succeeded", (String)"All variation points are now successfully assigned with a variability mechanism");
            return true;
        }
        MessageDialog.openWarning((Shell)this.getShell(), (String)"Recommender Failed", (String)"Not all variation points could be assigned with a variability mechanism");
        return false;
    }

    private List<VariabilityRefactoring> getRefactorings(List<String> refactoringIds) {
        ArrayList refactorings = Lists.newArrayList();
        for (String refactoringId : refactoringIds) {
            VariabilityRefactoring refactoring = (VariabilityRefactoring)VariabilityRefactoringRegistry.getInstance().getElementById((Object)refactoringId);
            if (refactoring != null) {
                refactorings.add(refactoring);
                continue;
            }
            logger.warn((Object)("Refactoring specified in splProfile not registered (" + refactoringId + ")"));
        }
        return refactorings;
    }

    private boolean checkAllMechanismsSelected(VariationPointModel vpm) {
        for (VariationPointGroup group : vpm.getVariationPointGroups()) {
            for (VariationPoint vp : group.getVariationPoints()) {
                if (vp.getVariabilityMechanism() != null && !Strings.isNullOrEmpty((String)vp.getVariabilityMechanism().getRefactoringID())) continue;
                return false;
            }
        }
        return true;
    }

    private VariationPointModel loadVPM() {
        SPLevoProject splevoProject = this.splevoProjectEditor.getSplevoProject();
        int index = splevoProject.getVpmModelReferences().size() - 1;
        VPMModelReference vpmReference = (VPMModelReference)splevoProject.getVpmModelReferences().get(index);
        ResourceSet rs = JobUtil.initResourceSet((SPLevoProject)splevoProject, (boolean)vpmReference.isRefactoringStarted());
        try {
            return VPMUtil.loadVariationPointModel((File)new File(vpmReference.getPath()), (ResourceSet)rs);
        }
        catch (IOException e) {
            logger.error((Object)"Failed to load VPM", (Throwable)e);
            return null;
        }
    }

    private boolean checkVPMExists() {
        boolean vpmExistCheck = true;
        if (this.splevoProjectEditor.getSplevoProject().getVpmModelReferences().size() == 0) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Variation Point Model Missing", (String)"No VPM available.");
            vpmExistCheck = false;
        }
        return vpmExistCheck;
    }
}

