/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.ui.listeners;

import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.ProgressMonitorPart;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.splevo.ui.editors.SPLevoProjectEditor;
import org.splevo.ui.wizards.vpmanalysis.VPMAnalysisWizard;
import org.splevo.ui.wizards.vpmanalysis.VPMAnalysisWizardPageChangeListener;
import org.splevo.ui.workflow.VPMAnalysisWorkflowConfiguration;

public class VPMAnalysisListener
extends MouseAdapter {
    private Logger logger = Logger.getLogger(VPMAnalysisListener.class);
    private SPLevoProjectEditor splevoProjectEditor = null;
    private VPMAnalysisWorkflowConfiguration config = null;
    private VPMAnalysisWizard vpmAnalysisWizard = null;

    public VPMAnalysisListener(SPLevoProjectEditor splevoProjectEditor) {
        this.splevoProjectEditor = splevoProjectEditor;
        this.config = this.buildWorflowConfiguration();
    }

    public void mouseUp(MouseEvent event) {
        Shell shell = event.widget.getDisplay().getActiveShell();
        this.vpmAnalysisWizard = new VPMAnalysisWizard(this.config);
        WizardDialog wizardDialog = this.createWizardDialog(shell, this.vpmAnalysisWizard);
        wizardDialog.addPageChangedListener((IPageChangedListener)new VPMAnalysisWizardPageChangeListener(this.vpmAnalysisWizard));
        if (wizardDialog.open() != 0) {
            this.logger.debug((Object)"Variation Point Analyses canceled");
            return;
        }
        if (!this.config.isValid()) {
            MessageDialog.openError((Shell)shell, (String)"Invalid Project Configuration", (String)this.config.getErrorMessage());
            return;
        }
    }

    private WizardDialog createWizardDialog(Shell shell, VPMAnalysisWizard vpmAnalysisWizard) {
        WizardDialog wizardDialog = new WizardDialog(shell, (IWizard)vpmAnalysisWizard){

            protected Control createDialogArea(Composite parent) {
                Control ctrl = super.createDialogArea(parent);
                this.getProgressMonitor();
                return ctrl;
            }

            protected IProgressMonitor getProgressMonitor() {
                ProgressMonitorPart monitor = (ProgressMonitorPart)super.getProgressMonitor();
                GridData gridData = new GridData(768);
                gridData.heightHint = 0;
                monitor.setLayoutData((Object)gridData);
                monitor.setVisible(false);
                return monitor;
            }
        };
        return wizardDialog;
    }

    private VPMAnalysisWorkflowConfiguration buildWorflowConfiguration() {
        VPMAnalysisWorkflowConfiguration defaultConfig = new VPMAnalysisWorkflowConfiguration();
        defaultConfig.setSplevoProjectEditor(this.splevoProjectEditor);
        defaultConfig.setPresentation(VPMAnalysisWorkflowConfiguration.ResultPresentation.REFINEMENT_BROWSER);
        return defaultConfig;
    }
}

