/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.ui.refinementbrowser.action;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.splevo.ui.SPLevoUIPlugin;
import org.splevo.ui.refinementbrowser.VPMRefinementBrowser;
import org.splevo.ui.refinementbrowser.action.ApplyRefinementsAction;
import org.splevo.vpm.refinement.Refinement;

public class ApplySelectedRefinementsAction
extends ApplyRefinementsAction {
    public ApplySelectedRefinementsAction(VPMRefinementBrowser vpmRefinementBrowser, String actionText) {
        super(vpmRefinementBrowser, actionText);
    }

    @Override
    protected List<Refinement> getRefinementsFromRefinementBrowser() {
        final List<Refinement> selectedRefinements = this.vpmRefinementBrowser.getSelectedRefinementsFromMainView();
        Iterable relevantSelectedRefinements = Iterables.filter(selectedRefinements, (Predicate)new Predicate<Refinement>(){

            public boolean apply(final Refinement selectedRefinement) {
                return !Iterables.any((Iterable)selectedRefinements, (Predicate)new Predicate<Refinement>(){

                    public boolean apply(Refinement possibleParent) {
                        return possibleParent.getSubRefinements().contains((Object)selectedRefinement);
                    }
                });
            }
        });
        Iterable fixedRelevantSelectedRefinements = Iterables.transform((Iterable)relevantSelectedRefinements, (Function)new Function<Refinement, Refinement>(){

            public Refinement apply(Refinement arg0) {
                Iterator iter = arg0.getSubRefinements().iterator();
                while (iter.hasNext()) {
                    Refinement r = (Refinement)iter.next();
                    if (selectedRefinements.contains(r)) continue;
                    arg0.getVariationPoints().addAll((Collection)r.getVariationPoints());
                    iter.remove();
                }
                return arg0;
            }
        });
        return Lists.newArrayList((Iterable)fixedRelevantSelectedRefinements);
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        return SPLevoUIPlugin.getImageDescriptor("icons/apply-refinements-selected.gif");
    }
}

