/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.ui.refinementbrowser.listener;

import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.splevo.ui.refinementbrowser.RefinementBrowserUtil;
import org.splevo.vpm.refinement.Refinement;
import org.splevo.vpm.refinement.RefinementReason;
import org.splevo.vpm.variability.VariationPoint;

public class HighlightConnectedVPListener
implements ISelectionChangedListener {
    public void selectionChanged(SelectionChangedEvent event) {
        TreeViewer treeViewer = RefinementBrowserUtil.getTreeViewer(event);
        Set<VariationPoint> selectedVPs = this.getSelectedVP(event);
        Refinement refinement = RefinementBrowserUtil.getRefinement(treeViewer);
        if (treeViewer == null || selectedVPs.size() < 1 || refinement == null) {
            return;
        }
        Set<VariationPoint> connectedVPs = this.getDirectConnectedVPs(selectedVPs, refinement);
        this.highlightConnectedTreeNodes(treeViewer, selectedVPs, connectedVPs);
    }

    private void highlightConnectedTreeNodes(TreeViewer treeViewer, Set<VariationPoint> selectedVPs, Set<VariationPoint> connectedVPs) {
        TreeItem[] treeItemArray = treeViewer.getTree().getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem treeItem = treeItemArray[n2];
            this.highlightConnectedTreeNodes(treeViewer, selectedVPs, connectedVPs, treeItem);
            TreeItem[] treeItemArray2 = treeItem.getItems();
            int n3 = treeItemArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                TreeItem subItem = treeItemArray2[n4];
                this.highlightConnectedTreeNodes(treeViewer, selectedVPs, connectedVPs, subItem);
                ++n4;
            }
            ++n2;
        }
    }

    private void highlightConnectedTreeNodes(TreeViewer treeViewer, Set<VariationPoint> selectedVPs, Set<VariationPoint> connectedVPs, TreeItem treeItem) {
        Font fontBold = this.getFont(treeViewer, 1);
        Font fontBoldItalic = this.getFont(treeViewer, 3);
        Font fontNormal = this.getFont(treeViewer, 0);
        if (selectedVPs.contains(treeItem.getData())) {
            treeItem.setFont(fontBoldItalic);
        } else if (connectedVPs.contains(treeItem.getData())) {
            treeItem.setFont(fontBold);
        } else {
            treeItem.setFont(fontNormal);
        }
    }

    private Set<VariationPoint> getDirectConnectedVPs(Set<VariationPoint> selectedVPs, Refinement refinement) {
        LinkedHashSet connectedVPs = Sets.newLinkedHashSet();
        connectedVPs.addAll(this.getConnectedVPs(selectedVPs, refinement));
        for (Refinement ref : refinement.getSubRefinements()) {
            connectedVPs.addAll(this.getConnectedVPs(selectedVPs, ref));
        }
        return connectedVPs;
    }

    private Set<VariationPoint> getConnectedVPs(Set<VariationPoint> selectedVPs, Refinement refinement) {
        LinkedHashSet connectedVPs = Sets.newLinkedHashSet();
        for (RefinementReason reason : refinement.getReasons()) {
            if (selectedVPs.contains(reason.getSource()) && !selectedVPs.contains(reason.getTarget())) {
                connectedVPs.add(reason.getTarget());
                continue;
            }
            if (!selectedVPs.contains(reason.getTarget()) || selectedVPs.contains(reason.getSource())) continue;
            connectedVPs.add(reason.getSource());
        }
        return connectedVPs;
    }

    private Font getFont(TreeViewer treeViewer, int style) {
        Tree control = treeViewer.getTree();
        return this.getFont((Control)control, style);
    }

    private Font getFont(Control control, int style) {
        FontDescriptor fontDescriptor = FontDescriptor.createFrom((Font)control.getFont());
        Font styledFont = fontDescriptor.setStyle(style).createFont((Device)Display.getCurrent());
        return styledFont;
    }

    private Set<VariationPoint> getSelectedVP(SelectionChangedEvent event) {
        LinkedHashSet vps = Sets.newLinkedHashSet();
        for (Object selectedElement : ((StructuredSelection)event.getSelection()).toList()) {
            if (!(selectedElement instanceof VariationPoint)) continue;
            vps.add((VariationPoint)selectedElement);
        }
        return vps;
    }
}

